// AppletClienteContador
//

import java.awt.*;

public class AppletClienteContador extends java.applet.Applet { 

  private TextField campoVeces, campoTiempo;
  private Button botonRun;
  private Ejemplo1.Contador c;

  public void init() { 
	// Crea un layout de 2 x 2 para poner los componentes graficos
    	setLayout(new GridLayout(2, 2, 10, 10));

	// Pone los componentes, y los inicializa
	add(new Label("Numero de veces: "));
	add(campoVeces = new TextField());
 	campoVeces.setText("1000");
	add(botonRun = new Button("Run"));
	add(campoTiempo = new TextField());
	campoTiempo.setEditable(false);

	try { 
	// Inicializa el ORB.
		showStatus("Inicializando el ORB");
		org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(this, null);

	// Bind al objeto Contador
		showStatus("Enlazando con el objeto Contador");
		c = Ejemplo1.ContadorHelper.bind(orb, "Contador 1");
	} catch(org.omg.CORBA.SystemException e) {
		showStatus("System Exception: " + e);
		e.printStackTrace(System.out);
	}
  }

  public boolean action(Event ev, Object arg) { 
	if ( ev.target == botonRun ) { 
	  try { 
		// Empieza con el valor del contador a 0
        	showStatus("Pone el contador a 0");
        	c.valor((int)0);

		// lee el numero de veces
		showStatus("Incrementando...");
		int veces = Integer.parseInt(campoVeces.getText());
		campoTiempo.setText(" ");

		// Calcula el tiempo inicial
		long t_inicial = System.currentTimeMillis();

		// Incrementa el contador el numero de veces especificado
		for (int i = 0 ; i < veces ; i++ )  c.inc();

		// Calcula el tiempo final y las estadisticas
 		long t_final = System.currentTimeMillis();
		campoTiempo.setText("Tiempo Medio = "
                  + Float.toString((float)(t_final - t_inicial)/veces)
                  + " msegs");
		showStatus("Contador = " + c.valor());
	  } 
	  catch(org.omg.CORBA.SystemException e) { 
		showStatus("System Exception" + e);
		e.printStackTrace();
	  }
	  return true;
	}
	return false;
  }
}
