// ClienteContador.java
// 
// Este cliente se conecta a un contador y calcula el tiempo
// medio de invocacion estatica
// 

class ClienteContador { 

  public static void main(String args[]) { 
	try { 
	// Inicializa el ORB
		System.out.println("Inicializa el ORB");
		org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);

	// Consigue la referencia al objeto Contador
		System.out.println("Consigue la referencia al objeto Contador");
		Ejemplo1.Contador c = Ejemplo1.ContadorHelper.bind(orb, "Contador 1");

	// Lee el valor del contador y lo imprime
		System.out.println("El Contador 1 tiene el valor: "+c.valor());

	// Calcula el tiempo de inicio
		long t_inicial = System.currentTimeMillis();

	// Llama a la operacion inc() 1000 veces
		System.out.println("Incrementando el contador...");
		for (int i = 0 ; i < 1000 ; i++ ) c.inc();

	// Calcula el tiempo final e imprime las estadisticas
		long t_final = System.currentTimeMillis();

		System.out.println("Tiempo medio de invocacion = "
                       + ((t_final - t_inicial)/1000f) + " msegs");
		System.out.println("Valor final del contador = " + c.valor());
	} 
	catch(org.omg.CORBA.SystemException e) { 
		System.err.println("System Exception: " + e);
	}
  }
}
