//  
//  BarraObservador.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Jun-1996  05:18:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.util.Observer;
import java.util.Observable;

public class BarraObservador extends Frame implements Observer {
    private ValorObservable vo = null;
    private Scrollbar sb = null;

    // Constructor que presenta una ventanita con la barra de 
    // desplazamiento para poder ir alterando los valores del
    // objeto observable
    public BarraObservador( ValorObservable vo ) {
        super( "Observador de Barra" );

        this.vo = vo;
        setLayout( new GridLayout( 0,1 ) );

        sb = new Scrollbar( Scrollbar.HORIZONTAL,vo.getValor(),10,
            vo.getLimiteInferior(),vo.getLimiteSuperior() );
        add( sb );
        pack();
        show();
        }


    // Manejamos los eventos que se producen al manipular la barra y
    // al destruir la ventana
    // Cuando desplazamos el marcador de la barra, vamos actualizando
    // el valor del objeto observable y presentamos el valor que
    // se ha adquirido
    public boolean handleEvent( Event evt ) {
        if( evt.id == Event.WINDOW_DESTROY )
            {
            vo.deleteObserver( this );
            dispose();
            return( true );
            }
        else if( evt.id == Event.SCROLL_LINE_UP )
            {
            vo.setValor( sb.getValue() );
            return( true );
            }
        else if( evt.id == Event.SCROLL_LINE_DOWN )
            {
            vo.setValor( sb.getValue() );
            return( true );
            }
        else if( evt.id == Event.SCROLL_PAGE_UP )
            {
            vo.setValor( sb.getValue() );
            return( true );
            }
        else if( evt.id == Event.SCROLL_PAGE_DOWN )
            {
            vo.setValor( sb.getValue() );
            return( true );
            }
        else if( evt.id == Event.SCROLL_ABSOLUTE )
            {
            vo.setValor( sb.getValue() );
            return( true );
            }
  
        return( super.handleEvent( evt ) );
        }


    // Actualizamos el valor que corresponde al numero que actualmente
    // tiene el objeto que estamos observando
    public void update( Observable obs,Object obj ) {
        if( obs == vo )
            sb.setValue( vo.getValor() );
        }
    }

//----------------------------------- Final del fichero BarraObservador.java
