//  
//  PanelControl.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 01-Nov-1996  08:13:30
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;
import java.util.Observable;

public class PanelControl extends Applet {
    private Button bObservTexto;
    private Button bObservBarra;
    private ValorObservable vo;

    public void init() {
        setLayout( new FlowLayout() );
        setBackground( Color.white );
        bObservTexto.setBackground( Color.lightGray );
        bObservBarra.setBackground( Color.lightGray );
        add( bObservTexto );
        add( bObservBarra );
        }

    public Dimension preferredSize() {
        return new Dimension( 200,70 );
        }

    public boolean action(Event evt,Object obj ) {
        if( evt.target == bObservTexto )
            {
            TextoObservador textoObserv = new TextoObservador( vo );
            vo.addObserver( textoObserv );
            return( true );
            }
        if( evt.target != bObservBarra )
            return( false );

        BarraObservador barraObserv = new BarraObservador( vo );
        vo.addObserver( barraObserv );
        return( true );
        }

    public static void main( String string[] ) {
        Frame frame = new Frame( "Panel de Control" );
        PanelControl panel = new PanelControl();
        
		panel.init();
        frame.add( "Center",panel );
        frame.pack();
        frame.show();
        }

    public PanelControl() {
        bObservTexto = new Button( "Nuevo Observador Texto" );
        bObservBarra = new Button( "Nuevo Observador Barra" );
        vo = new ValorObservable( 0,0,1000 );
        }
    }

//------------------------------------- Final del fichero PanelControl.java
