//  
//  TextoObservador.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 30-Sep-1996  09:24:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.util.Observer;
import java.util.Observable;

public class TextoObservador extends Frame implements Observer {
    private ValorObservable vo = null;
    private TextField tf = null;
    private Label l = null;
    private int nInferior = 0;
    private int nSuperior = 0;

    // Constructor en el que creamos una ventana donde poder introducir
    // el valor numerico que represente la cantidad que corresponda
    // al objeto observable
    public TextoObservador( ValorObservable vo ) {
        super("Observador de Texto");

        this.vo = vo;
        setLayout( new GridLayout( 0,1 ) );
        nInferior = vo.getLimiteInferior();
        nSuperior = vo.getLimiteSuperior();

        tf = new TextField( String.valueOf( vo.getValor() ) );
        add( tf );

        l = new Label();
        add( l );

        pack();
        show();
        }


    // Controlamos el evento que proviene del campo de texto, cuando se
    // introduce un valor numerico
    public boolean action( Event evt,Object obj ) {
        if( evt.target == tf ) 
            {
            int n = 0;
            boolean bValido = false;

            try {
                n = Integer.parseInt( tf.getText() );
                bValido = true;
            } catch( NumberFormatException nfe ) {
                bValido = false;
                }
            
            // Comprobamos que no se sobrepasen los limites que hemos
            // fijado
            if( n < nInferior || n > nSuperior )
                bValido = false;

            if( bValido )
                {
                vo.setValor( n );
                l.setText( "" );
                }
            else
                l.setText( "Valor no valido - intentelo de nuevo" );

            return( true );
            }

        return( false );
        }


    // Controlamos el cierre de la ventana, para eliminar el objeto
    // que hemos creado antes de hacer desaparecer la ventana
    public boolean handleEvent( Event evt ) {
        if( evt.id == Event.WINDOW_DESTROY )
            {
            vo.deleteObserver( this );
            dispose();
            return( true );
            }   
  
        return( super.handleEvent( evt ) );
        }


    // Actualizamos el valor del objeto que estamos observando en
    // nuestro campo de texto, para reflejar el valor actual del
    // objeto
    public void update( Observable obs,Object obj ) {
        if( obs == vo )
            tf.setText( String.valueOf( vo.getValor() ) );
        }
    }

//----------------------------------- Final del fichero TextoObservador.java
