//  
//  ValorObservable.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 30-Sep-1996  08:56:05
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.util.Observable;

public class ValorObservable extends Observable {
    private int nValor = 0;
    private int nInferior = 0;
    private int nSuperior = 0;

    // Constructor al que indicamos el valor en que comenzamos y los
    // limites inferior y superior que no deben sobrepasarse
    public ValorObservable( int nValor,int nInferior,int nSuperior ) {
       this.nValor = nValor;
       this.nInferior = nInferior;
       this.nSuperior = nSuperior;
       }


    // Fija el valor que le pasamos y notifica a los observadores que
    // estan pendientes del cambio de estado de los objetos de esta
    // clase, que su etado se ha visto alterado
    public void setValor(int nValor) {
       this.nValor = nValor;

       setChanged();
       notifyObservers();
       }


    // Devuelve el valor actual que tiene el objeto
    public int getValor() {
       return( nValor );
       }


    // Devuelve el limite inferior del rango de valores en los que se ha
    // de mover el objeto
    public int getLimiteInferior() {
       return( nInferior );
       }


    // Devuelve el limite superior del rango de valores en los que se ha
    // de mover el objeto
    public int getLimiteSuperior() {
       return( nSuperior );
       }
    }

//----------------------------------- Final del fichero ValorObservable.java
