//  
//  BotonImg.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 11-Sep-1996  11:35:43
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.awt.image.*;
import java.applet.*;
import java.net.*;

public class BotonImg {
    private Applet appSuperior;
    public Image imagen;
    public Image imagenUp;
    public Image imagenDown;
    public Image imagenMove;
    public ImageFilter filtro;
    public String mensaje;
    public int estado;
    public int offX;
    public int offY;
    public int tamX;
    public int tamY;
    public URL url;
    public String href;

	// En este mtodo vamos fijando las imgenes que se presentarn en funcin
	// del estado en que se encuentre el ratn
	// Utilizamos un mtodo que Java proporciona en la clase java.awt.imagen
	// que nos permite extraer una zona de una imagen y guardarla como imagen
	// completa. De este modo extraemos del dibujo que contiene las tres imgenes
	// posibles, cada imagen correspondiente a los eventos que le llegan al
	// objeto enviados por el ratn
    public void init() {
        filtro = new CropImageFilter( 0,0,tamX,tamY );
        imagenUp = appSuperior.createImage( 
            new FilteredImageSource( imagen.getSource(),filtro ) );
        filtro = new CropImageFilter( 0, tamY,tamX,tamY );
        imagenMove = appSuperior.createImage( 
            new FilteredImageSource( imagen.getSource(),filtro ) );
        filtro = new CropImageFilter( 0,tamY*2,tamX,tamY );
        imagenDown = appSuperior.createImage( 
            new FilteredImageSource( imagen.getSource(),filtro ) );
		// Aqu componemos la direccin a la que saltar cuando se pique con el 
		// ratn la zona que corresponda al botn
        try {
            url = new URL( appSuperior.getDocumentBase(),href );
        } catch( MalformedURLException e ) {
            url = null;
            }
        return;
        }

	// Constructor, al que le pasamos el applet que correponde al dibujo completo
    public BotonImg( Applet applet ) {
        appSuperior = applet;
        }

	// Sobrecargamos el mtodo showDocument, para que no se abra con las
	// caractersticas del applet del botn, sino con las del padre, que s
	// tendr las caractersticas de la pgina 
    public void showDocument( URL uRL ) {
        appSuperior.getAppletContext().showDocument( uRL );
        }

	// En este mtodo, pintamos un dibujo u otro sobre el botn, en funcin del
	// estado que nos devuelva el sistema para el cursor y los botones del
	// ratn
    public void paint( Graphics g ) {
        if( estado == 0 )
            g.drawImage( imagenUp,offX,offY,appSuperior );
        else if(estado == 1)
            g.drawImage( imagenDown,offX,offY,appSuperior );
        else if( estado == 2 )
            g.drawImage( imagenMove,offX,offY,appSuperior );
        }

	// En los tres mtodos que siguen, controlamos los eventos que nos llegan del
	// ratn. La tcnica a seguir es la misma en cada uno de ellos, mirar si
	// el cursor se encuentra dentro del campo de accin del botn que estamos
	// trantando, si no est dentro del campo del botn, pero s dentro del
	// dibujo general del applet, devolvemos el control al applet general para
	// que siga comprobando si est el cursor sobre otro botn. Si el cursor se
	// encuentra en nuestro campo de accin, actuamos en consecuencia
    public boolean mouseDown( Event evt,int i,int j ) {
        if( i >= offX  &&  i < offX + tamX  && 
            j >= offY  &&  j < offY + tamY )
            {
			// Fijamos el estado a 1, para que cuando se suelte el botn
			// podamos saltar a la direccin que se haya especificado en la
			// lista de parmetros del applet
            estado = 1;
            appSuperior.repaint();
            }
        else if( estado != 0 )
            {
            appSuperior.showStatus( "" );
            estado = 0;
            appSuperior.repaint();
            }
        return( false );
        }

    public boolean mouseUp( Event evt,int i,int j ) {
        if( i >= offX  &&  i < offX + tamX  && 
            j >= offY  &&  j < offY + tamY )
            {
			// Si previamente habamos pulsado el ratn sobre este botn, hacemos
			// que se muestre la pgina correcpondiente a la direccin URL que se
			// haba cargado
            if( estado == 1 )
                showDocument( url );
            estado = 2;
            appSuperior.repaint();
            }
        else if( estado != 0 )
            {
            appSuperior.showStatus( "" );
            estado = 0;
            appSuperior.repaint();
            }
        return( false );
        }

    public boolean mouseMove( Event evt,int i,int j ) {
        if( i >= offX  &&  i < offX + tamX  && 
            j >= offY  &&  j < offY + tamY )
            {
			// Si slo movemos el cursor sobre el botn, nos limitamos a presentar
			// el mensaje que se ha definido en los parmetros de llamada al 
			// applet
            estado = 2;
            appSuperior.showStatus( mensaje );
            appSuperior.repaint();
            }
        else if( estado != 0 )
            {
            appSuperior.showStatus( "" );
            estado = 0;
            appSuperior.repaint();
            }
        return( false );
        }
    }

//------------------------------------------ Final del fichero BotonImg.java
