//  
//  Calculadora.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 12-Sep-1996  15:39:38
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Calculadora extends Applet {
    TextField pantallita;
    public final int OP_NADA = 0;
    public final int OP_SUMA = 1;
    public final int OP_RESTA = 2;
    public final int OP_MULT = 3;
    public final int OP_DIV = 4;
    public final int OP_IGUAL = 5;
    public final int OP_BORRAR_C = 6;
    public final int OP_BORRAR_AC = 7;
    public final int PUNTO_DECIMAL = -1;

    String cadDecimal;
    int operador = OP_NADA;
    boolean nuevoNumero = true;
    boolean esDecimal = false;
    double Total = 0.0;
    boolean esConstante = false;
    double numConstante = 0.0;
    int opConstante = OP_NADA;

    public void init() {
        BotonCalculadora bot0,bot1,bot2,bot3,bot4,bot5,bot6,bot7,bot8,bot9;
        BotonCalculadora botDecimal,botSuma,botResta;
        BotonCalculadora botMult,botDiv,botIgual,botBorraC,botBorraAC;

        // No utilizamos ningn la layout porque vamos a colocar
        // los botones y el campo de texto para mostrar el resultado
        // de las operaciones, en posiciones fijas
        setLayout( null );
        setFont( new Font( "Helvetica",Font.PLAIN,14 ) );
        setBackground( new Color( 0x66,0xA2,0xD4 ) );

        // Pintamos los botones de los numeros 
        bot0 = new BotonCalculadora( "0",OP_NADA,0 );
        add( bot0 );
        bot0.reshape( 8,144,96,24 );
        bot1 = new BotonCalculadora( "1",OP_NADA,1 );
        add( bot1 );
        bot1.reshape( 8,112,40,24 );
        bot2 = new BotonCalculadora( "2",OP_NADA,2 );
        add( bot2 );
        bot2.reshape( 64,112,40,24 );
        bot3 = new BotonCalculadora( "3",OP_NADA,3 );
        add( bot3 );
        bot3.reshape( 120,112,40,24 );
        bot4 = new BotonCalculadora( "4",OP_NADA,4 );
        add( bot4 );
        bot4.reshape( 8,80,40,24 );
        bot5 = new BotonCalculadora( "5",OP_NADA,5 );
        add( bot5 );
        bot5.reshape( 64,80,40,24 );
        bot6 = new BotonCalculadora( "6",OP_NADA,6 );
        add( bot6 );
        bot6.reshape( 120,80,40,24 );
        bot7 = new BotonCalculadora( "7",OP_NADA,7 );
        add( bot7 );
        bot7.reshape( 8,48,40,24 );
        bot8 = new BotonCalculadora( "8",OP_NADA,8 );
        add( bot8 );
        bot8.reshape( 64,48,40,24 );
        bot9 = new BotonCalculadora( "9",OP_NADA,9 );
        add( bot9 );
        bot9.reshape( 120,48,40,24 );	

        // Pintamos los botones que nos van a permitir realizar las
        // operaciones soportadas poe esta mini-calculadora
        botDecimal = new BotonCalculadora( "",OP_NADA,PUNTO_DECIMAL );
        add( botDecimal );
        botDecimal.reshape( 120,144,40,24 );
        botSuma = new BotonCalculadora( "+",OP_SUMA,0 );
        add( botSuma );
        botSuma.reshape( 176,112,40,56 );
        botResta = new BotonCalculadora( "-",OP_RESTA,0 );
        add( botResta );
        botResta.reshape( 232,112,40,24 );
        botMult = new BotonCalculadora( "*",OP_MULT,0 );
        add( botMult );
        botMult.reshape( 176,80,40,24 );
        botDiv = new BotonCalculadora( "/",OP_DIV, 0);
        add( botDiv );
        botDiv.reshape( 176,48,40,24 );
        botIgual = new BotonCalculadora( "=",OP_IGUAL,0 );
        add( botIgual );
        botIgual.reshape( 232,144,40,24 );
        botBorraC = new BotonCalculadora( "C",OP_BORRAR_C,0 );
        add( botBorraC );
        botBorraC.reshape( 232,48,40,24 );
        botBorraAC = new BotonCalculadora( "AC",OP_BORRAR_AC,0 );
        add( botBorraAC );
        botBorraAC.reshape( 232,80,40,24 );

        // Pintamos el campo de texto en que vamos a reflejar lo que se
        // se va introduciendo y el resultado de las operaciones
        pantallita = new TextField( "0",80 );
        pantallita.setEditable( false );
        add( pantallita );
        pantallita.reshape( 48,8,184,31 );
        String unaDecima = ( new Double(0.1) ).toString();
        cadDecimal = 
            unaDecima.substring( unaDecima.length()-2 ).substring( 0,1 );
        }


    public static void main( String args[] ) {
        Frame f = new Frame( "Calculadora Java" );
        Calculadora c = new Calculadora();

        c.init();
        f.add( "Center",c );
        f.pack();
        f.resize( 395,181 );
        f.show();
        }


    public void anadir( int valor ) {
        String digito;

        // Controlamos el punto decimal, para que si es lo primero que se
        // pulsa, desplazar un cero a la izquierda, y si se pulsa cuando
        // ya estamos en un numero decimal, no hacerle caso
        if( valor == PUNTO_DECIMAL )
            if( !esDecimal )
                {
                if( nuevoNumero )
                    {
                    pantallita.setText( "0" );
                    nuevoNumero = false;
                    }
                esDecimal = true;
                digito = cadDecimal;
                }
            else
                return; 
        else
            digito = ( new Integer(valor) ).toString();

        // Si tenemos que presentar un numero nuevo, porque estemos ya en
        // otra operacion, borramos antes la pantallaita
        if( nuevoNumero )
            {
            pantallita.setText( digito );
            if( valor != 0 )
                nuevoNumero = false;
            }
        else
            pantallita.setText( pantallita.getText() + digito );

        repaint();
        }


    // Ejecuta la operacion que indica el operador del boton que se
    // haya pulsado
    public void haceOperacion( int nuevoOperador ) {
        double numero;

        numero = ( new Double( pantallita.getText() ) ).doubleValue();
        switch( nuevoOperador )
            {
            case OP_SUMA:
            case OP_RESTA:
            case OP_MULT:
            case OP_DIV:
                if( nuevoNumero )
                    {
                    if( nuevoOperador == operador && !esConstante )
                        {
                        esConstante = true;
                        numConstante = numero;
                        opConstante = nuevoOperador;
                        }
                    else
                        esConstante = false;
                    }
                else
                    esConstante = false;
            case OP_IGUAL:
                if( !nuevoNumero || esOperadorIgual( nuevoOperador ) )
                    {
                    if( esConstante )
                        {
                        Total = numConstante;
                        operador = opConstante;
                        }

                    // Controla los operadores de operaciones
                    // matematicas
                    switch( operador )
                        {
                        case OP_SUMA:
                            Total = Total + numero;
                            break;
                        case OP_RESTA:
                            Total = Total - numero;
                            break;
                        case OP_MULT:
                            Total = Total * numero;
                            break;
                        case OP_DIV:
                            Total = Total / numero;
                            break;
                        case OP_IGUAL:
                        case OP_NADA:
                            Total = numero;
                            break;
                        }

                    // Presenta el resultado del tecleo en la pantalla
                    pantallita.setText(( new Double(Total) ).toString());
                    }
                operador = nuevoOperador;
                nuevoNumero = true;
                esDecimal = false;
                break;
            }

        // Controla los operadores de borrado tanto el Clear como el
        // AllClear
        switch( nuevoOperador )
            {
            // Borra el numero y cancela la operacion en curso
            // solamente
            case OP_BORRAR_C:
                numero = 0.0;
                pantallita.setText( "0" );
                if( esOperadorIgual( operador ) )
                    Total = numero;
                nuevoNumero = true;
                esDecimal = false;
                break;
            // Borra todas las operaciones y numeros, lo deja
            // todo a cero
            case OP_BORRAR_AC:
                pantallita.setText( "0" );
                operador = OP_NADA;
                nuevoNumero = true;
                esDecimal = false;
                Total = 0.0;
                esConstante = false;
                break;
            }
        }


    // Comprueba si es el operador igual, para presentar resultado
    private protected boolean esOperadorIgual( int oper ) {
        return( oper == OP_IGUAL );
        }
    }


// Esta clase se utiliza para pintar cada uno de los botones que van
// a conformar la calculadora
class BotonCalculadora extends Button {
    int operador;
    int bvalor;

    BotonCalculadora( String texto, int oper, int valor ) {
        super( texto );
        operador = oper;
        bvalor = valor;   
        }


    public boolean action( Event evt, Object arg ) {
        Calculadora par = ( Calculadora )getParent();

        // Si no se tiene ninguna operacion matematica asociada, solamente 
        // se aade el numero a la pantallita, y si ya es una
        // operacion, entonces se hace y se presenta el resultado
        if( operador == par.OP_NADA )
            par.anadir( bvalor );
        else
            par.haceOperacion( operador );

        return( true );
        }
    }

//--------------------------------------- Final del fichero Calculadora.java
