//*************************************************************************
// Cartel.java:    Applet                                                 //      
//                                                                        //      
// Propiedad LAO  1996 Luis Angel Ortega Todos los derechos reservados   //     
//                                                                        //
// Permiso para usar copiar, modificar, y distribuir este software        //
// y su documentacion, sin propositos comerciales.                        //
//                                                                        //
// Para cualquier duda o comentario con el autor lao@arrakis.es           //
//                                                                        //
// Pagina WEB http://wwww.arrakis.es/~lao                                 //
//                                                                        //
// El autor no se resposabiliza de posibles daos que el software         //
// pueda efectuar en cualquier equipo informatico.                        //
//                                                                        //
//                                                                        //
// Autor: Luis Angel Ortega LAO  25/11/1996                               //
// Creado con Microsoft Visual J++ Version 1.0                            //
//                                                                        //
// El Applet es de libre distribucion, presenta un texto que se           //
// desplaza a derecha o izquierda.                                        //
//                                                                        //
// Los parmetros son los siguientes:                                     //
//                                                                        //
//   ==================================================================== //
//  PARAMETROS                             | VALORES DE LOS PARAMETROS    //
//  ===================================================================== //
//    TEXTO = Cadena de texto a desplazar. | "Texto a desplazar"          //
//  ===================================================================== //
//    DESPLAZAMIENTO = Desplazar el texto  | "IZQUIERDA"                  //
//    a izquierda o derecha.                 | "DERECHA"                  //
//    =================================================================== //
//    COLORFONDO = Color para el fondo     | "ROJO"                       // 
//  del texto.                             | "AZUL"                       //
//                                         | "NEGRO"                      //
//                                         | "BLANCO"                     //
//    =================================================================== //
//    COLORTEXTO = Color para el texto     | "ROJO"                       // 
//                                         | "AZUL"                       //
//                                         | "NEGRO"                      //
//                                         | "BLANCO"                     //
//    =================================================================== //
//    WIDTH = Ancho del Applet             | Un numero mayor que 12.      //
//    =================================================================== //
//    HEIGHT = Ancho del Applet             | Un numero mayor que 12.     //
//    =================================================================== //
//    VELOCIDAD =Velocidad en milisegundos | Un numero mayor que 1        //
//    de la actualizacin en pantalla del  |                              //
//    applet, depende de la velocidad del  |                              //
//    ordenador donde se visualiza el      |                              //
//    applet                                 |                            //
//    =================================================================== //
//                                                                        //
//  Notas:                                                                //
//     El parmetro de la VELOCIDAD es opcional, por defecto es 10.       //
//     El texto se ajusta automticamente al alto del Applet.             //
//     La velocidad de desplazamiento depende de la velocidad del         //
//   procesador.                                                          //
//   Los valores de los parmetros pueden ser en minsculas o maysculas. //
//                                                                        //
//  Ejemplo:                                                              //
//                                                                        //
//        <applet code="Cartel.class"                                     //
//        width="200" height="50" id="Cartel">                            //
//        <param name="COLORFONDO" value="negro">                         //
//        <param name="COLORTEXTO" value="rojo">                          //
//        <param name="TEXTO" value="Ejemplo de Applet">                  //
//        <param name="DESPLAZAMIENTO" value="izquierda">                 //
//        <param name="VELOCIDAD" value="5">                              //
//        Tu Visualizador WEB no puede ejecutar cdigo JAVA</applet>      //
//                                                                        //
//*************************************************************************

import java.applet.*;
import java.awt.*;

public class Cartel extends Applet implements Runnable
{

    Thread     m_Cartel = null;
    
    // Todas las constantes y Variables excepto Texto, son declaradas
    // privadas para no poder ser usadas desde otra clase
    // constantes
    private final int RESTAFONT = 14; 
    
    // Variables
    private int Velocidad;     // Velocidad del thread en milisegundos
    private int CordY;         // Cordenada y donde situar el texto
    private int CordX;         // Cordenada x donde situar el texto
    private int StringAncho;   // Ancho de la cadena a desplazar
    private int SizeDescent;
    private Font font;         // Tipo de letra del texto
    private Dimension d;       // Dimensiones del applet
    // La misin de estas tres variables es almacenar un objeto grfico
    // en memoria, que es una copia del objeto que se crea al pintar el applet.
    private Dimension offDimension; 
    private Image offImage;
    private Graphics offGraphics;
    
    private Color ColorTexto;  // Color del texto
    private Color ColorFondo;  // Color del fondo
    public String Texto;       // Texto a desplazar
    private boolean Scroll;    // TRUE=Izquierda FALSE=Derecha
    
    //**********************************************************************//
    // Metodo Actualizar()                                                  //
    // Utilizado para poder cambiar los parametros del applet, mediante     //
    // codigo en JavaScript o VBscript.                                     //
    // Nota:                                                                //
    //  Es posible cambiar el texto sin llamar al metodo Actualizar         //
    //                                                                      //
    // Entrada:                                                             //
    //      String Text = Texto a desplazar.                                //
    //      String Desplaza = Desplaza el texto a "IZQUIERDA O "DERECHA"    //
    //        String ColFondo    =  Cambia el color del fondo               //
    //                         "ROJO","AZUL","NEGRO","BLANCO"               //
    //        String ColTexto    =  Cambia el color del texto               //
    //                         "ROJO","AZUL","NEGRO","BLANCO"               //
    //      String Veloc  = Velocidad del Thread en milisegundos.           //
    //                                                                      //
    // Salida: void                                                         //
    //**********************************************************************//

    public void Actualizar (String Text,String Desplaza,String ColFondo, 
                            String ColTexto, String Veloc) 
    {
     
     try {
     
     // Comprueba si los datos pasados al metodo son los correctos
     ColFondo = ColFondo.toUpperCase(); // Lo convierte a Mayusculas
     
     ColorFondo = (ColFondo.compareTo("ROJO")==0) ? Color.red : ColorFondo;
     ColorFondo = (ColFondo.compareTo("AZUL")==0) ? Color.blue : ColorFondo;
     ColorFondo = (ColFondo.compareTo("NEGRO")==0) ? Color.black : ColorFondo;
     ColorFondo = (ColFondo.compareTo("BLANCO")==0) ? Color.white : ColorFondo;

     ColTexto = ColTexto.toUpperCase(); // Lo convierte a Mayusculas
     ColorTexto = (ColTexto.compareTo("ROJO")==0) ? Color.red : ColorTexto;
     ColorTexto = (ColTexto.compareTo("AZUL")==0) ? Color.blue : ColorTexto;
     ColorTexto = (ColTexto.compareTo("NEGRO")==0) ? Color.black : ColorTexto;
     ColorTexto = (ColTexto.compareTo("BLANCO")==0) ? Color.white : ColorTexto;
    
     Desplaza = Desplaza.toUpperCase(); // Lo convierte a Mayusculas
     Scroll = (Desplaza.compareTo("DERECHA")==0) ? false : true;     
     
     Texto=Text;
     offGraphics = null; // La proxima vez que pinte crea un nuevo Graphics
     } catch (NullPointerException e) { // Ejecuta este codigo en el caso que
          ColorTexto = Color.red;       // algunas de las cadenas que preceden
         ColorFondo = Color.black;      // al catch sean un nulo
         Scroll = true;
         Texto= "Parametro del applet incorrecto";
          Velocidad=10;
      }
    }

    //**********************************************************************//
    // Metodo CogerParametros()                                             //
    // Recoge los valores pasados como parametros dentro del codigo HTML    //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: void                                                         //
    //**********************************************************************//

    void CogerParametros () 
    {
    
    try {
    String Parametro=getParameter("VELOCIDAD");// Obtiene el parametro velocidad
    
    Integer Veloc=Integer.valueOf(Parametro);  // Convierte el String en un 
                                               // objeto tipo Integer
    
    Velocidad=Veloc.intValue(); // Convierte el valor del objeto Integer 
                                // en un entero (int)
     
    } catch (NumberFormatException e) {    // La cadena introducida como parametro
                                           // no es un numero entero
       Velocidad=10;                       // Establece la velocidad del Thread 
                                           //  en 10 milisegundos
       
    } catch (NullPointerException e ) {    // Cadena introducida es un nulo
       Velocidad=10;
    }

    try {
      
     // Coge los parametros del applet, los compara y almacena en variables
     // el valor adecuado
     String Parametro=getParameter ("COLORFONDO");
     Parametro=Parametro.toUpperCase(); // Lo convierte a Mayusculas
     ColorFondo = (Parametro.compareTo("ROJO")==0) ? Color.red : ColorFondo;
     ColorFondo = (Parametro.compareTo("AZUL")==0) ? Color.blue : ColorFondo;
     ColorFondo = (Parametro.compareTo("NEGRO")==0) ? Color.black : ColorFondo;
     ColorFondo = (Parametro.compareTo("BLANCO")==0) ? Color.white : ColorFondo;

     Parametro=getParameter ("COLORTEXTO");
     Parametro=Parametro.toUpperCase(); // Lo convierte a Mayusculas
     ColorTexto = (Parametro.compareTo("ROJO")==0) ? Color.red : ColorTexto;
     ColorTexto = (Parametro.compareTo("AZUL")==0) ? Color.blue : ColorTexto;
     ColorTexto = (Parametro.compareTo("NEGRO")==0) ? Color.black : ColorTexto;
     ColorTexto = (Parametro.compareTo("BLANCO")==0) ? Color.white : ColorTexto;

     Parametro=getParameter ("DESPLAZAMIENTO");
     Parametro=Parametro.toUpperCase(); // Lo convierte a Mayusculas
     Scroll = (Parametro.compareTo("DERECHA")==0) ? false : true;     

     Texto=getParameter ("TEXTO");      // Coge el texto

     }    
     catch (NullPointerException e) {   // Excepcion producida por alguna 
                                        // cadena vacia o nula
          ColorTexto = Color.red;
         ColorFondo = Color.black;
         Scroll = true;
         Texto = "Parametro del applet incorrecto";
     } 
    }

    //**********************************************************************//
    // Metodo update()                                                      //
    // Es llamado por el metodo repaint(), cada vez que se dispara el thread//
    //                                                                      //
    // La primera vez que es llamado crea una copia en memoria              //
    // (doble buffer) del objeto Graphics g.                                //
    // Una vez creado, todos los elementos graficos, son dibujados          //
    // sobre el buffer offGraphics, una vez dibujados son mostrados en la   //
    // pantalla del sistema.                                                //
    //                                                                      //
    // Entrada: Graphics g                                                  //
    //                                                                      //
    // Salida: void                                                         //
    //**********************************************************************//

    public void update (Graphics g) 
    {
       // Si offGraphics no existe o cambia de tamao lo crea
       if ( (offGraphics == null) ||
            (d.width != offDimension.width) ||
            (d.height != offDimension.height) ) {
              offDimension = d;
              offImage = createImage (d.width, d.height); // Crea la imagen en 
                                                          // memoria
              offGraphics = offImage.getGraphics(); // Almacena el objeto 
                                                    // grafico en memoria
                 
              // Establece el font
              offGraphics.setFont (font);
              
              // Establece la medida descent del Font
              FontMetrics fontmetrics = offGraphics.getFontMetrics();
              SizeDescent = fontmetrics.getDescent();
              // Almacena el ancho del la cadena
              StringAncho = fontmetrics.stringWidth(Texto); 
                
              // Establece las cordenadas de comienzo dependiendo de la variable
              // Scroll (desplazamiento a derecha o izquierda) 
              CordX  = Scroll ? d.width : -StringAncho;  
              CordY=(d.height-SizeDescent)-7;
       }
              

       // Borra la imagen previa que tenemos en el buffer
       offGraphics.setColor(getBackground());
       offGraphics.fillRect(0,0, d.width , d.height);
       offGraphics.setColor (Color.black);
       
       offGraphics.setColor (ColorFondo);  // Establece el color de fondo
       offGraphics.fillRect (0,0,d.width,d.height); // Rellena el fondo
       
       offGraphics.setColor(ColorTexto);   // Establece el color de texto
       offGraphics.drawString (Texto,CordX,CordY);  // Pinta el texto
       
       CordX= Scroll ? --CordX : ++CordX;  //Suma o resta la cordenada X,
                                           // dependiendo del valor de la 
                                           // variable Scroll    

       // Comprueba si el texto que se desplaza llega al final del margen
       // izquierdo o derecho del applet
       if (CordX == d.width )  CordX=-StringAncho; //Derecha
       else if (CordX == -StringAncho)  CordX=d.width; // Izquierda

       // Dibuja el marco del applet
       offGraphics.setColor (Color.lightGray);
       offGraphics.fill3DRect (0,0,d.width,5,true);
       offGraphics.fill3DRect (0,(d.height-5),d.width,5,true);
       offGraphics.fill3DRect (0,0,5,d.height,true);
       offGraphics.fill3DRect ((d.width-5),0,5,d.height,true);

       g.drawImage (offImage, 0 ,0 ,this); // Muestra la imagen almacenada 
                                           // en el buffer
    }

    //**********************************************************************//
    // Metodo Cartel()                                                      //
    // Constructor de la clase                                              //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: void                                                         //
    //**********************************************************************//

    public Cartel()
    {
         // Sin codigo
    }

    //**********************************************************************//
    // Metodo getAppletInfo()                                               //
    //                                                                      //
    // Retorna los datos del applet, autor y sistema de desarrollo          //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: String                                                       //
    //**********************************************************************//

    public String getAppletInfo()
    {
        return "Name: Cartel\r\n" +
               "Author: Luis Angel Ortega LAO  25/11/1996\r\n" +
               "Created with Microsoft Visual J++ Version 1.0";
    }

    //**********************************************************************//
    // Metodo init                                                          //
    //                                                                      //
    // Este metodo es llamado por el AWT cuando el applet es cargado por    //
    // primera vez, o necesita ser recargado.                               //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//

    public void init()
    {
        d = size(); // Almacena las dimensiones del applet
        resize(d.width,d.height); // Redimensiona el applet de nuevo
                                  // Es nesario en el caso de que se vuelva a
                                  // cargar el applet
         
        Toolkit toolkit = Toolkit.getDefaultToolkit(); 
        String h[] = toolkit.getFontList(); // Almacena en h todos los 
                                            // tipos de letra
        
        // Crea un nuevo font con con el atributo de normal
        // y el tamao del ancho del applet menos RESTAFONT (14)
        font = new Font (h[1],Font.PLAIN,(d.height-RESTAFONT)); 
        
        CogerParametros();        // Llama al metodo para coger los 
                                  // parametros del applet
    }

    //**********************************************************************//
    // Metodo destroy()                                                     //
    //                                                                      //
    // Este metodo es llamado cuando el applet es destruido de memoria      //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//

    public void destroy()
    {
        // Sin codigo
    }

    //**********************************************************************//
    // Metodo paint()                                                       //
    //                                                                      //
    // Este metodo es llamado cuando el applet necesita ser pintado.        //
    // Si colocamos una ventana que oculte el applet, o parte del mismo,    //
    // desplazamos o quitamos la ventana, se produce el evento paint.       //
    //                                                                      //
    //    Nota:                                                             //
    //   La llamada de repaint no produce necesariamente la llamada al paint//
    //                                                                      //
    // Entrada: Graphics g                                                  //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//

    public void paint(Graphics g)
    {
        if (offImage != null ) { // Si offImage existe visuliza la imagen 

            g.drawImage(offImage, 0 ,0 ,this);
        }
    }    

    //**********************************************************************//
    // Metodo start                                                         //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//
    public void start()
    {
        if (m_Cartel == null) // Si no existe el Thread lo crea
        {
            m_Cartel = new Thread(this);
            m_Cartel.start(); // Produce la llamada al metodo run()
        }
    }
    
    
    //**********************************************************************//
    // Metodo stop                                                          //
    //                                                                      //
    // Este metodo se produce cuando cambiamos  de pagina o cerramos        //
    // el visualizador                                                      //
    // La llamada al metodo provoca la parada del Thread                    //
    //                                                                      //
    // Entrada: Ninguna                                                     //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//
    
    public void stop()
    {
        if (m_Cartel != null) // Provoca la parada del Thread
        {
            m_Cartel.stop();
            m_Cartel = null;
        }
    }

    //**********************************************************************//
    // Metodo run()                                                         //
    //                                                                      //
    // Este metodo es llamado cuando el applet del Thread es llamado        //
    //                                                                      //
    // Entrada:Ninguna                                                      //
    //                                                                      //
    // Salida: Void                                                         //
    //**********************************************************************//

    public void run()
    {
        while (true) // Produce un bucle infinito
        {
            try
            {
                repaint(); // Llama al metodo update()
                Thread.sleep(Velocidad); // Establece la velocidad del Thread
            }
            catch (InterruptedException e) // Excepcion
            {
                stop(); // Llama al metodo stop() para el Thread
            }
        }
    }

}  //Final del la clase

