//  
//  CuerpoFicha.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 11-Sep-1996  11:35:43
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Presenta el cuerpo de la ficha en blanco, para que se puedan insertar los
// componentes que correspondan
// Es el contenedor del control tabular que estamos implementando
public class CuerpoFicha extends Panel {

    // Lo unico que se pasa al constructor de esta clase es el color de
    // fondo con que queremos que aparezca 
    public CuerpoFicha( Color colorCuerpo ) {
        setBackground( colorCuerpo );
        }

    public void paint( Graphics g ) {
        Rectangle area;

        area = bounds();

        // Pintamos el fondo del cuerpo de la ficha con el color 
        // que se haya indicado en el constructor de la clase
        g.setColor( getBackground() );
        g.fillRect( area.x,area.y + 1,area.width,area.height-1 );
 
        // Pintamos una linea brillante el los lados superior e
        // izquierdo 
        g.setColor( Color.white );
        g.drawLine( area.x,area.y,area.x+area.width,area.y );
        g.drawLine( area.x,area.y,area.x,area.y+area.height );

        // Pintamos una linea gris en los lados inferior y derecho
        // para dar sensacion de sombra
        g.setColor( Color.gray );
        g.drawLine( area.x,area.y+area.height-1,
            area.x+area.width-1,area.y+area.height-1 );
        g.drawLine( area.x+area.width-1,area.y+area.height-1,
            area.x+area.width-1,area.y+1 );

        // Pintamos la sombra de la sobra de los lados inferior y
        // derecho, para aumentar la sensacion de tres dimensiones y
        // profundidad
        g.setColor( Color.black );
        g.drawLine( area.x,area.y+area.height,
            area.x+area.width,area.y+area.height );
        g.drawLine( area.x+area.width,area.y+area.height,
            area.x+area.width,area.y+1 );
        }
    }

//--------------------------------------- Final del fichero CuerpoFicha.java
