//  
//  EjPotenciometro.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 16-Dic-1996  17:13:51
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.*;

public class EjPotenciometro extends Applet {
    Button izda;
    Button dcha;
    Button todo;
    TextField inds;
    TextField inds1;
    Potenciometro s;
    Potenciometro s1;
    
    public void init() {
        setBackground( Color.lightGray );
        setLayout( null );

        // Utilizamos el componente Grupo que ya tenemos desarrollado
        // Para agrupar los componentes de esta demo. El primer
        // Grupo agrupa a todos los elementos: barras, botones, textos
        Grupo g = new Grupo( "Ejemplo de Potencimetro" );
        add( g );
        g.setFont( new Font( "Dialog",0,12 ) );
        g.reshape( insets().left+20,insets().top+20,520,250 );
        g.setLayout( null );
        // Creamos un potencimetro vertical
        s = new Potenciometro( 0,150,2 );
        g.add( s );
        s.reshape( 40,50,42,180 );
        s.setValor( 0 );
        inds = new TextField( Integer.toString( s.getValor()),4 );
        g.add( inds );
        inds.reshape( 36,20,45,28 );
        // Creamos otro potencimetro, horizontal
        s1 = new Potenciometro( 0,240,1 );
        g.add( s1 );
        s1.reshape( 120,35,365,40 );
        s1.setValor( 0 );
        inds1 = new TextField( Integer.toString( s1.getValor()),4 );
        g.add( inds1 );
        inds1.reshape( 420,80,50,28 );

        // Este otro grupo engloba a los botones que permiten posicionar
        // las marcas por encima o debajo de la barra
        Grupo g2 = new Grupo( "Posicin Indicador" );
        g.add( g2 );
        g2.reshape( 105,150,400,70 );
        izda = new Button( "Izquierda/Arriba" );
        g2.add( izda );
        izda.reshape( 15,25,120,30 );
        dcha = new Button( "Derecha/Abajo" );
        g2.add( dcha );
        dcha.reshape( 145,25,110,30 );
        todo = new Button( "Ambas Posiciones" );
        g2.add( todo );
        todo.reshape( 265,25,125,30 );
        }

    public boolean handleEvent( Event evt ) {
        System.out.println( "Target "+evt.target );
        System.out.println( "    ID "+evt.id );
        // Controlamos los eventos de los botones para posicionar 
        // las marcas y del propio potencimetro para controlar
        // la posicion del indicador y el valor en el texto
        if( evt.target == izda && evt.id == 1001 )
            {
            s.setPosicionMarca( 1 );
            s.update();
            s1.setPosicionMarca( 1 );
            s1.update();
            return( true );
            }
        if( evt.target == dcha && evt.id == 1001 )
            {
            s.setPosicionMarca( 2 );
            s.update();
            s1.setPosicionMarca( 2 );
            s1.update();
            return( true );
            }
        if( evt.target == todo && evt.id == 1001 )
            {
            s.setPosicionMarca( 3 );
            s.update();
            s1.setPosicionMarca( 3 );
            s1.update();
            return( true );
            }
        if( evt.target == s && evt.id == 1001 )
            {
            inds.setText( Integer.toString( s.getValor() ) );
            return( true );
            }
        if( evt.target == s1 && evt.id == 1001 )
            {
            inds1.setText( Integer.toString( s1.getValor() ) );
            return( true );
            }
        switch( evt.id ) {
            default:
                return( false );
            }
        }
    }

//----------------------------------- Final del fichero EjPotenciometro.java
