//  
//  Ficha.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 12-Sep-1996  11:43:24
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.lang.String;
import CuerpoFicha;
import Solapa;

// Crea un objeto que sera seleccionado cuando se pulse con el raton
// en su solapa. Contiene a dos objetos, uno de tipo Solapa y otro de
// tipo cuerpoFicha, de forma que al seleccionar en el primero
// aparecera la solapa marcada y el contenido del objeto cuerpoFichero
// asociado a esa solapa
public class Ficha extends Panel {
    public static final int SOLAPA_SELECCIONADA = 2000;
    protected Solapa solapa;
    protected CuerpoFicha cuerpoFicha;

    public Ficha( String rotulo,Font normFont,Font seleFont,
        Color colorRotulo,Color colorFicha ) {
        super();
        solapa = new Solapa( rotulo,normFont,seleFont, 
            colorRotulo,colorFicha );
        cuerpoFicha = new CuerpoFicha( colorFicha );
        }


    // Devuelve el rotulo identificador de la solapa
    public String getRotulo() {
        return( solapa.getRotulo() );
        }


    // Devuelve los limites del cuerpo de la Ficha
    public Rectangle getBordesFicha() {
        return( cuerpoFicha.bounds() );
        }


    // Devuelve los limites que ocupa la solapa
    public Rectangle getBordesSolapa() {
        return( solapa.bounds() );
        }


    // Devuelve el punto final, ams alejado de la solapa
    public Point getFinalSolapa() {
        return( solapa.getFinal() );
        }


    public boolean handleEvent( Event evt ) {
        // La solapa devolvera true solamente si ha sido seleccionada
        // en ese momento por el evento, aunque lo que siempre haremos
        // sera notificarlo a ListaFichas, por lo que devolvemos false
        // y el evento SOLAPA_SELECCIONADA se propagara hacia arriba
        if( solapa.handleEvent( evt ) ) 
            {
            evt.id = SOLAPA_SELECCIONADA;
            evt.arg = this;
            }
        return( false );
        }


    // Indica si la ficha esta seleccionada o no
    public boolean estaSeleccionada() {
        return( solapa.estaSeleccionada() );
        }


    public void medidas( Point solapaXY,Graphics g,
        Dimension appTam,Point appPos ) {
        FontMetrics fm;
        int anchoRotulo;
        int altoRotulo;

        fm = g.getFontMetrics( solapa.getFuenteSel() );
        anchoRotulo = fm.stringWidth( solapa.getRotulo() );
        altoRotulo = fm.getHeight();
        solapa.reshape( solapaXY.x,solapaXY.y,anchoRotulo+altoRotulo,
            altoRotulo+(altoRotulo / 3) );
        cuerpoFicha.reshape( appPos.x,appPos.y+solapa.getAlto(),
            appTam.width-1,appTam.height-solapa.getAlto()-1 );
        }


    public void paint( Graphics g ) {
        if( estaSeleccionada() ) 
            cuerpoFicha.paint( g );
        solapa.paint( g );
        }


    public void seleccionar() {
        solapa.seleccionar();
        }


    public void deSeleccionar() {
        solapa.deSeleccionar();
        }
    }

//--------------------------------------------- Final del fichero Ficha.java
