//  
//  ListaFichas.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 12-Sep-1996  12:46:13
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.util.Vector;
import Ficha;

public class ListaFichas extends Panel {
    protected Vector fichas;
    protected Point posicion;
    protected Dimension tama;
    protected Font normFont;
    protected Font seleFont;
    protected Color fgColor;
    protected Color bgColor;
    protected Panel contenido;

    public ListaFichas( Point posicion,Dimension tama,Font normFont,
        Font seleFont,Color fgColor,Color bgColor,
        String primerRotulo,Panel primerPanel ) {

        super();
       
        // Aqui fijamos el layout a null, porque el metodo medidas()
        // sera el que controle ese layout
        setLayout( null );      

        // Nos creamos un objeto Vector, que nos va a permitir la
        // manipulacion de la lista de las fichas
        fichas = new Vector();
        this.posicion = posicion;
        this.tama = tama;
        this.normFont = normFont;
        this.seleFont = seleFont;
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        contenido = new Panel();
        add( contenido );
        contenido.setLayout( new CardLayout() );

        // Incorporamos la primera ficha y la dejamos seleccionada
        addFicha( primerRotulo,primerPanel );
        primeraFicha().seleccionar();
        }


    // En este metodo incorporamos una ficha a la lista, con todos
    // los valores por defecto
    public synchronized void addFicha( String rotulo,Panel panel ) {
        fichas.addElement( new Ficha( rotulo,normFont,seleFont, 
            fgColor,bgColor) );
        contenido.add( rotulo,panel );
        }


    // En este metodo, nos permitimos especificar los colores de
    // primer plano y de fondo con que se va a presentar la ficha
    // en pantalla, a demas de incorporarla a la lista de fichas
    public synchronized void addFicha( Color fgColor,Color bgColor,
        String rotulo,Panel panel ) {
        fichas.addElement( new Ficha( rotulo,normFont,seleFont, 
            fgColor,bgColor ) );
        contenido.add( rotulo,panel );
        }


    // Presenta el contenido de la ficha que se ha seleccionado
    public void presentaFichaSeleccionada() {
        ( (CardLayout)contenido.getLayout() ).show( contenido,
            ( getSeleccionada().getRotulo() ) );
        }


    // Devuelve la primera ficha de la lista
    public synchronized Ficha primeraFicha() {
        return( (Ficha)fichas.firstElement() );
        }


    // Devuelve el contenido del control Tabular completo
    public Panel getContenido() {
        return contenido;
        }


    // Devuelve la siguiente ficha a la que se le pasa como parametro
    public synchronized Ficha getSigFicha( Ficha f ) {
        Ficha nextF;

        // La numeracion de los elementos empieza en 0 
        if( fichas.indexOf( f ) < (fichas.size() - 1) ) 
            nextF = fichaAt( fichas.indexOf(f)+1 );
        else 
            nextF = null;
        
        return( nextF );
        }


    // Devuelve la ficha que actualmente esta seleccionada
    public synchronized Ficha getSeleccionada() {
        Ficha f;

        // Nos colocamos en la primera y vamos comprobando
        // ficha por ficha cual es la que esta seleccionada
        f = primeraFicha();
        while( (!f.estaSeleccionada()) && (f != null) ) 
            f = getSigFicha( f );
    
        return( f );
        }


    // Devuelve informacisn de si el evento se ha controlado o no
    // en este manejador
    public boolean handleEvent( Event evt ) {
        boolean manejado;
        Ficha  f;

        // Localizamos la ficha que ha generado el evento
        f = primeraFicha();
        manejado = f.handleEvent( evt );
        if( !manejado ) 
            f = getSigFicha( f );
        while( (f != null) && (!manejado) ) 
            {
            manejado = f.handleEvent( evt );
            f = getSigFicha( f );
            }

        // Si han seleccionado otra ficha, liberamos la actualmente
        // seleccionada y seleccionamos la que nos llega en el
        // evento, que correponde a la solapa que se ha pulsado
        if( evt.id == Ficha.SOLAPA_SELECCIONADA ) 
            {
            getSeleccionada().deSeleccionar();
            ( (Ficha)evt.arg ).seleccionar();
            presentaFichaSeleccionada();
            repaint();
            manejado = true;
            }

        // Si aqui no se ha controlado el evento, se intenta que lo
        // controle directamente alguno de los componentes que se
        // hayan colocado en la ficha
        if( !manejado ) 
            manejado = contenido.handleEvent( evt );

        return( manejado );
        }


    // Devuelve la ultima ficha del control Tabular
    public synchronized Ficha ultimaFicha() {
        return( (Ficha)fichas.lastElement() );
        }


    // Calcula el area que ocupa todo el Control Tabular
    public void medidas( Graphics g ) {
        Ficha f;
        Point solapaXY;

        // Calcula el area ocupada por las solapas
        tama = size();
        f = primeraFicha();
        solapaXY = new Point( posicion.x+2,posicion.y+2 );
        f.medidas( solapaXY,g,tama,posicion );
        if( f != ultimaFicha() ) 
            {
            do {
                solapaXY = f.getFinalSolapa();
                f = getSigFicha( f );
                f.medidas( solapaXY,g,tama,posicion );
               } while( f != ultimaFicha() );
            }

        // Calcula el area ocupada por los paneles que forman el
        // cuerpo de las fichas
        Rectangle r = primeraFicha().getBordesSolapa();
        contenido.move( r.x+3,r.y+r.height+3 );
        r = primeraFicha().getBordesFicha();
        contenido.resize( r.width-10,r.height-10 );
        }


    public void paint( Graphics g ) {
        Ficha f;

        medidas( g );
        f = primeraFicha();
        while( f != null ) 
            {
            if( !f.estaSeleccionada() ) 
                f.paint( g );
            f = getSigFicha( f );
            }
        getSeleccionada().paint( g );
        contenido.paintAll( g );
        }


    // Devuelve la ficha que se encuentre en la posicion que se indique
    // en el indice que se pasa como paramentro
    public synchronized Ficha fichaAt( int indice ) {
        Ficha f;

        // Capturamos la excepcion de que se nos vaya fuera de
        // limites el indice que nos pasan
        try {
            f = (Ficha)fichas.elementAt( indice );
        } catch( ArrayIndexOutOfBoundsException e ) {
            System.out.println("Error : No hay ficha #" + indice );
            return( null );
            }
        return( f );
        }
    }

//--------------------------------------- Final del fichero ListaFichas.java
