//  
//  MenuDeBotones.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 29-Oct-1996  11:44:46
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

public class MenuDeBotones extends AppletFijo {
    private int colFondo;
    BotonImg tit;
    BotonImg dem;
    BotonImg ovw;
    BotonImg faq;
    BotonImg res;
    Image fondo;

    // En este mtodo leemos todos los datos que se pasan desde la llamada
    // al applet en la pgina HTML. Por cada una de las opciones que se
    // encuentren en la pgina, crearemos un objeto BotonImg que sera el
    // que controle los movimientos del ratn sobre ese Boton
    public void init() {
        colFondo = Integer.parseInt( getParameter( "Color" ),16 );
        // Carga la imagen de fondo
        fondo = getImage( getCodeBase(),getParameter( "Fondo" ) );

        // Obtenemos los datos del botn que corresponder a la opcin de
        // "Java WorkShop - Home Page"
        tit = new BotonImg( this );
        // Esta es la posicin X,Y en la que se coloca la imagen del botn
        // sobre la imagen principal
        tit.offX = Integer.valueOf( getParameter( "tit.offX" ) ).intValue();
        tit.offY = Integer.valueOf( getParameter( "tit.offY" ) ).intValue();
        // Este es el tamao de la imagen que corresponde al botn en ancho y
        // alto. En la imagen asociada que contiene las distintas imgenes de
        // estados en que se puede encotnrar el botn, nos encontraremos con
        // tres imgenes diferentes que estarn despalazadas en Y justamente
        // el tamao en altura que ocupa cada botn
        tit.tamX = Integer.valueOf( getParameter( "tit.tamX" ) ).intValue();
        tit.tamY = Integer.valueOf( getParameter( "tit.tamY" ) ).intValue();
        // Esta es el dibujo que contiene las tres imgenes en que va a poder
        // presentarse este botn
        tit.imagen = getImage( getCodeBase(),getParameter( "tit.imagen" ) );
        // Este es el mensaje que aparecer en la zona de estado del Navegador
        // cuando el cursor del ratn pase por la zona ocupada por el botn
        tit.mensaje = getParameter( "tit.mensaje" );
        // Esta es la direccin URL a la que se saltar cuando se acte sobre
        // el botn
        tit.href = getParameter( "tit.href" );
        tit.init();

        // Obtenemos los datos del botn que corresponder a la opcin de
        // "Demo Download Area & Product Pricing"
        // Los parmetros son los mismos que en el caso anterior
        dem = new BotonImg( this );
        dem.offX = Integer.valueOf(getParameter( "dem.offX" ) ).intValue();
        dem.offY = Integer.valueOf(getParameter( "dem.offY" ) ).intValue();
        dem.tamX = Integer.valueOf(getParameter( "dem.tamX" ) ).intValue();
        dem.tamY = Integer.valueOf(getParameter( "dem.tamY" ) ).intValue();
        dem.imagen = getImage( getCodeBase(),getParameter( "dem.imagen" ) );
        dem.mensaje = getParameter( "dem.mensaje" );
        dem.href = getParameter( "dem.href" );
        dem.init();
        
        // Obtenemos los datos del botn que corresponder a la opcin de
        // "Development Tools Overview & Tutorials"
        // Los parmetros son los mismos que en el caso anterior
        ovw = new BotonImg( this );
        ovw.offX = Integer.valueOf(getParameter( "ovw.offX" ) ).intValue();
        ovw.offY = Integer.valueOf(getParameter( "ovw.offY" ) ).intValue();
        ovw.tamX = Integer.valueOf(getParameter( "ovw.tamX" ) ).intValue();
        ovw.tamY = Integer.valueOf(getParameter( "ovw.tamY" ) ).intValue();
        ovw.imagen = getImage( getCodeBase(),getParameter( "ovw.imagen" ) );
        ovw.mensaje = getParameter( "ovw.mensaje" );
        ovw.href = getParameter( "ovw.href" );
        ovw.init();
        
        // Obtenemos los datos del botn que corresponder a la opcin de
        // "Java WorkShop FAQ"
        faq = new BotonImg(this);
        faq.offX = Integer.valueOf( getParameter( "faq.offX" ) ).intValue();
        faq.offY = Integer.valueOf( getParameter( "faq.offY" ) ).intValue();
        faq.tamX = Integer.valueOf( getParameter( "faq.tamX" ) ).intValue();
        faq.tamY = Integer.valueOf( getParameter( "faq.tamY" ) ).intValue();
        faq.imagen = getImage( getCodeBase(),getParameter("faq.imagen" ) );
        faq.mensaje = getParameter( "faq.mensaje" );
        faq.href = getParameter( "faq.href" );
        faq.init();
        
        // Obtenemos los datos del botn que corresponder a la opcin de
        // "Resources"
        res = new BotonImg( this );
        res.offX = Integer.valueOf(getParameter( "res.offX" ) ).intValue();
        res.offY = Integer.valueOf(getParameter( "res.offY" ) ).intValue();
        res.tamX = Integer.valueOf(getParameter( "res.tamX" ) ).intValue();
        res.tamY = Integer.valueOf(getParameter( "res.tamY" ) ).intValue();
        res.imagen = getImage( getCodeBase(),getParameter( "res.imagen" ) );
        res.mensaje = getParameter( "res.mensaje" );
        res.href = getParameter( "res.href" );
        res.init();
        }

    // Aqu pintamos la imagen de fondo y le pasamos el control a cada uno de los
    // botones para que controles la imagen que deben pintar en funcin de la
    // accin que se realiza sobre ellos
    public void paint( Graphics g ) {
        g.setColor( new Color( colFondo ) );
        g.fillRect( 0,0,size().width,size().height );
        g.drawImage( fondo,0,0,this );
        tit.paint( g );
        dem.paint( g );
        ovw.paint( g );
        faq.paint( g );
        res.paint( g );
        }

    // Ahora en los mtodos que controlan los estados de los botones del ratn,
    // pasamos el control a los botones, para que cambien la imagen que
    // corresponde al botn sobre el que est actuando el ratn, ya sea solamente
    // movindose sobre l o actuando con los botones sobre la zona que
    // corresponde a ese botn
    public boolean mouseUp( Event evt,int i,int j ) {
        tit.mouseUp( evt,i,j );
        dem.mouseUp( evt,i,j );
        ovw.mouseUp( evt,i,j );
        faq.mouseUp( evt,i,j );
        res.mouseUp( evt,i,j );
        return( false );
        }

    public boolean mouseDown( Event evt,int i,int j ) {
        tit.mouseDown( evt,i,j );
        dem.mouseDown( evt,i,j );
        ovw.mouseDown( evt,i,j );
        faq.mouseDown( evt,i,j );
        res.mouseDown( evt,i,j );
        return( false );
        }

    public boolean mouseMove( Event evt,int i,int j ) {
        tit.mouseMove( evt,i,j );
        dem.mouseMove( evt,i,j );
        ovw.mouseMove( evt,i,j );
        faq.mouseMove( evt,i,j );
        res.mouseMove( evt,i,j );
        return( false );
        }

    public MenuDeBotones() {}
    }

//------------------------------------- Final del fichero MenuDeBotones.java
