//  
//  Persiana.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 17-Oct-1996  06:22:56
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Persiana extends Applet implements Runnable {
    Image imagenFondo;
    Image offI;
    Graphics offG;
    int posicion;
    String texto[];
    Font font;
    Font font1;
    Font font2;
    Font font3;
    boolean puedePintar;
    Thread thrd;
    MediaTracker mdt;

    public void init() {
        mdt = new MediaTracker( this );

        // Instanciacin de los objetos fuente que vamos a utilizar durante 
        // la presentacin del texto en su desplazamiento por la persiana
        font = new Font( "Arial",0,15 );
        font1 = new Font( "Helv",1,23 );
        font2 = new Font( "TimesNewRoman",1,30 );
        font3 = new Font( "Arial",1,16 );

        // Cadenas de texto correspondientes al primer grupo de informacin
        // que se va a presentar en la ventana
        texto[0] = "Este Tutorial de Java proporciona suficientes conocimientos";
        texto[1] = "para que, tanto los programadores noveles como aquellos que ya";
        texto[2] = "conocen las bondades del lenguaje Java, puedan acercarse en un";
        texto[3] = "caso y profundizar en el otro, en los ms diversos aspectos del";
        texto[4] = "lenguaje. Se recorren casi todas las caractersticas de Java,";
        texto[5] = "desde las ms sencillas como puede ser la descripcin de los";
        texto[6] = "tipos soportados por el lenguaje, hasta las ms complicadas";
        texto[7] = "como la implementacin de un entorno cliente-servidor o el";
        texto[8] = "desarrollo de un modelo de arquitectura Modelo-Vista completo.";

        // Informacin que se presentar a continuacin del ttulo
        // del segundo bloque de informacin de la persiana
        texto[9] = "Se hace un profundo recorrido por el Abstract Window Toolkit,";
        texto[10] = "presentado todos los elementos que lo componen en su actual";
        texto[11] = "versin, con mltiples lneas de cdigo fuente para que el";
        texto[12] = "navegante pueda ir comprobando cmo se usan y cmo Java";
        texto[13] = "utiliza los recursos que pone en manos del programador.";
        texto[14] = "Tambin hay mltiples applets Java en funcionamiento a lo";
        texto[15] = "largo del Tutorial, de forma que se puede ir comprobando";
        texto[16] = "la apariencia que presentan los applets sobre el browser que";
        texto[17] = "estemos utilizando.";

        // Bloque final de informacin
        texto[18] = "Como compendio a todo lo desarrollado en este Tutorial de";
        texto[19] = "Java, se presentan varias aplicaciones autnomas y algunos";
        texto[20] = "applets listos para utilizar, con toda la informacin";
        texto[21] = "necesaria para su implementacin y uso.";

        // Recuperamos la imagen que se va a utilizar como fondo de la
        // cadena que represente el ttulo principal de la persiana
        imagenFondo = getImage( getCodeBase(),"fondo.gif" );
        try {
            offI = createImage( 700,55 );
            offG = offI.getGraphics();
        } catch( Exception e ) {
            offG = null;
            }
        return;
        }



    public void update( Graphics g ) {
        if( puedePintar )
            paint( g );
        }



    public void paint( Graphics g ) {
        if( offG != null )
            {
            paintApplet( offG );
            g.drawImage( offI,0,0,this );
            return;
            }
        paintApplet( g );
        }



    public void paintApplet( Graphics g ) {
        // Presentamos la imagen de fondo y el ttulo principal que
        // queremos asignar a la infromacin que va a ir presentando
        // la persiana.
        // Para hacer un poco ms atractiva la visualizacin del ttulo
        // hacemos que aparezca una especie de sombra de la cadena de
        // texto. Para ello, simplemente la volvemos a escribir pero
        // desplazada
        g.setColor( Color.black );
        g.fillRect( 0,0,600,700 );
        g.setFont( font2 );
        g.drawImage( imagenFondo,0,-posicion,this );
        g.setColor( Color.white );
        g.drawString( "Tutorial de Java",200,50-posicion );
        g.setColor( Color.blue );
        g.drawString( "Turorial de Java",198,48-posicion );
        g.setColor( Color.orange );
        g.setFont( font1 );
        g.fillRect( 130,60-posicion,190,24 );
        g.setColor( Color.black );
        g.drawString( "Presentacin",150,80-posicion );
        g.setColor( Color.white );
        g.setFont( font );
        for( int i=0; i < 9; i++ )
            g.drawString( texto[i],5,105+i*19-posicion );

        // Creamos otro rectngulo de color para colocar el ttulo que
        // encabeza al grupo de cadenas que van a seguir desplazndose 
        // por la persiana
        g.setColor( Color.white );
        g.fillRect( 120,265-posicion,180,26 );
        g.setColor( Color.red );
        g.setFont( font1 );
        g.drawString( "AWT",180,287-posicion );
        g.setColor( Color.white );
        g.setFont( font );
        for( int j=9; j < 18; j++ )
            g.drawString( texto[j],5,140+j*19-posicion );

        // Presentamos el siguiente grupo de informacin, creando una
        // cabecera para indicar de qu se trata la informacin que va a
        // aparecer en la persiana
        g.setColor( Color.red );
        g.fillRect( 120,471-posicion,200,30 );
        g.setColor( Color.white );
        g.setFont( font1 );
        g.drawString( "Ejemplos",165,493-posicion );
        g.setColor( Color.white );
        g.setFont( font );
        for( int j=18; j < 22; j++ )
            g.drawString( texto[j],5,177+j*19-posicion );

        // Esta es la misma informacin que la del principio
        g.setFont( font2 );
        g.drawImage( imagenFondo,0,600-posicion,this );
        g.setColor( Color.white );
        g.drawString( "Tutorial de Java",200,650-posicion );
        g.setColor( Color.blue );
        g.drawString( "Tutorial de Java",198,648-posicion );
        }


    public void start() {
        // Creamos un nuevo thread y lo arrancamos
        thrd = new Thread( this );
        thrd.start();
        }


    public void stop() {
        thrd.stop();
        }


    public void run() {
        for( puedePintar=false; true; puedePintar=false )
            {
            try {
                puedePintar = true;
                repaint();
                // Si estamos al principio, alargamos un poco la espera
                if( posicion == 0 )
                    {
                    Thread.currentThread();
                    Thread.sleep( 5000 );
                    }
                posicion++;
                // Cuando lleguemos al final del texto, volvemos al
                // principio, para repetir todos los mensajes
                if( posicion == 600 )
                    posicion = 0;
                Thread.currentThread();
                // Aqui podemos hacer ms rpido o ms lento el 
                // desplazamiento del texto por la persiana
                Thread.sleep( 100 );
            } catch( InterruptedException e ) {
                ;
                }
            }
        }



    // El constructor del applet se limita a crear el array de texto que
    // contendr todas las cadenas o lneas de texto que se irn pasando
    // por la ventana
    public Persiana() {
        texto = new String[22];
        }
    }

//------------------------------------------ Final del fichero Persiana.java
