//  
//  Potenciometro.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 16-Dic-1996  16:25:46
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

public class Potenciometro extends Canvas {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int IZQUIERDA = 1;
    public static final int DERECHA = 2;
    public static final int SUBIR = 3;
    public static final int BAJAR = 4;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = 2;
    public static final int SUP_INF = 3;
    boolean boolDrag;
    int valor;
    int Max;
    int Min;
    int x_offset;
    int y_offset;
    int hat_high;
    int espacioMarca;
    int posicion;
    int linIncremento;
    int pagIncremento;
    int hat_offset;
    int orientacion;
    int posicionMarca;
    Image offscreen;
    static Font defFuente;

    public Potenciometro( int min,int max,int orient ) {
        this( min,max,orient,3 );
        }

    public Potenciometro( int min,int max,int orient,int posMarca ) {
        boolDrag = false;
        Max = 100;
        hat_high = 12;
        espacioMarca = 30;
        linIncremento = 1;
        pagIncremento = 30;
        orientacion = 1;
        posicionMarca = 3;
        Max = max;
        Min = min;
        valor = Min;
        posicionMarca = posMarca;
        orientacion = orient;
        setFont( defFuente );
        }

    // Mtodo que utilizamos para fijar los marcadores en un valor
    // determinado
    // Aqu se encuentran todos los mtodos de get() y set() que se
    // utilizan para fijar y recuperar los valores de los parmetros
    // que controlan al potencimetro
    public void setValor( int v ) {
        Dimension d = size();
        valor = v;
        if( orientacion == 2 )
            {
            posicion = d.height-hat_high - (valor-Min) * 
                (d.height-hat_high) / (Max-Min);
            return;
            }
        posicion = d.width-hat_high - (valor-Min) * 
            (d.width-hat_high) / (Max-Min);
        }

    public int getValor() {
        return( valor );
        }

    public void setMaximo( int v ) {
        Max = v;
        }

    public int getMaximo() {
        return( Max );
        }

    public void setMinimo( int v ) {
        Min = v;
        }

    public int getMinimo() {
        return( Min );
        }

    public void setEspacioMarca( int f ) {
        espacioMarca = f;
        }

    public int getEspacioMarca() {
        return( espacioMarca );
        }

    public void setPosicionMarca( int p ) {
        posicionMarca = p;
        }

    public int getPosicionMarca() {
        return( posicionMarca );
        }

    public void setPagIncremento( int i ) {
        pagIncremento = i;
        }

    public int getPagIncremento() {
        return( pagIncremento );
        }

    public void setLinIncremento( int i ) {
        linIncremento = i;
        }

    public int getLinIncremento() {
        return( linIncremento );
        }

    public void setOrientacion( int o ) {
        orientacion = o;
        }

    public int getOrientacion() {
        return( orientacion );
        }

    // Repintamos el potencimetro, slo una de las posiciones
    public void paint( Graphics g ) {
        if( orientacion == 1 )
            {
            printHSlider( g );
            return;
            }
        printVSlider( g );
        }


    // Pinta el potencimetro vertical
    public void printVSlider( Graphics g ) {
        Dimension d = size();
        x_offset = 17;
        y_offset = 4;
        g.setColor( Color.lightGray );
        g.fill3DRect( x_offset,y_offset,4,d.height-2*y_offset,false );
        g.setColor( Color.black );
        g.drawLine( x_offset+1,y_offset+1,x_offset+1,d.height-y_offset-2 );
        g.setColor( Color.lightGray );
        g.fill3DRect( 5,posicion,27,hat_high,true );
        g.setColor( getForeground() );

        int delta = espacioMarca*d.height/Max;
        for( int y = hat_high/2; y < d.height-hat_high/2; y += delta )
            {
            if( posicionMarca != 2 )
                g.drawLine( 0,y,3,y );
            if( posicionMarca != 1 )
                g.drawLine( 33,y,36,y );
            }

        if( posicionMarca != 2 )
            g.drawLine( 0,d.height-hat_high/2,3,d.height-hat_high/2 );
        if( posicionMarca != 1 )
            g.drawLine( 33,d.height-hat_high/2,36,d.height-hat_high/2 );
        if( posicionMarca != 2 )
            drawTriangulo( g,9,posicion+3,3,1,true );
        if( posicionMarca != 1 )
            drawTriangulo( g,27,posicion+3,3,2,true );
        }

    
    // Pinta el potencimetro horizontal
    public void printHSlider( Graphics g ) {
        Dimension d = size();
        y_offset = 17;
        x_offset = 4;
        g.setColor( Color.lightGray );
        g.fill3DRect( x_offset,y_offset,d.width-2*x_offset,4,false );
        g.setColor( Color.black );
        g.drawLine( x_offset+1,y_offset+1,d.width-x_offset-2,y_offset+1 );
        g.setColor( Color.lightGray );
        g.fill3DRect( posicion,5,hat_high,27,true );
        g.setColor( getForeground() );

        int delta = espacioMarca*d.width/Max;
        for( int x=hat_high/2; x < d.width-hat_high/2; x += delta )
            {
            if( posicionMarca != 2 )
                g.drawLine( x,0,x,3 );
            if( posicionMarca != 1 )
                g.drawLine( x,33,x,36 );
            }

        if( posicionMarca != 2 )
            g.drawLine( d.width-hat_high/2,0,d.width-hat_high/2,3 );
        if( posicionMarca != 1 )
            g.drawLine( d.width-hat_high/2,33,d.width-hat_high/2,36 );
        if( posicionMarca != 2 )
            drawTriangulo( g,posicion+3,9,3,3,true );
        if( posicionMarca != 1 )
            drawTriangulo( g,posicion+3,27,3,4,true );
        }


    public void update() {
        Dimension d = size();

        if( offscreen == null )
            offscreen = createImage( d.width,d.height );
        if( offscreen == null )
            return;

        Graphics offg = offscreen.getGraphics();
        Graphics g = getGraphics();
        offg.clipRect( 0,0,d.width,d.height );
        offg.setFont( getFont() );
        offg.setColor( getBackground() );
        offg.fillRect( 0,0,d.width,d.height );
        offg.setColor( g.getColor() );
        paint( offg );
        g.clipRect( 0,0,d.width,d.height );
        g.drawImage( offscreen,0,0,this );
        }


    // Ahora controlamos los eventos que nos llegan del ratn, que son
    // el pique y el arrastre
    public boolean onMouseDown( int x,int y ) {
        Dimension d = size();

        if( orientacion == 2 && y > posicion && y < posicion+hat_high )
            {
            hat_offset = y-posicion;
            boolDrag = true;
            return( true );
            }
        if( orientacion == 1 && x > posicion && x < posicion+hat_high )
            {
            hat_offset = x-posicion;
            boolDrag = true;
            return( true );
            }
        if( orientacion == 2 )
            {
            if( y < posicion )
                posicion = (posicion > pagIncremento) ? 
                    (posicion-pagIncremento) : 0;
            else if( y > posicion )
                posicion = (posicion < d.height-hat_high-pagIncremento) ? 
                    (posicion+pagIncremento) : (d.height-hat_high);
            valor = Min + (Max-Min) * (d.height-hat_high-posicion) / 
                (d.height-hat_high);
            }
        if( orientacion == 1 )
            {
            if( x < posicion )
                posicion = (posicion > pagIncremento) ? 
                    (posicion-pagIncremento) : 0;
            else if( x > posicion )
                posicion = (posicion < d.width-hat_high-pagIncremento) ? 
                    (posicion+pagIncremento) : (d.width-hat_high);
            valor = Min + (Max-Min) * (d.width-hat_high-posicion) / 
                (d.width-hat_high);
            }
        update();
        return( true );
        }


    public boolean onMouseDrag( int x,int y ) {
        Dimension d = size();

        if( boolDrag && orientacion == 2 )
            {
            posicion = y-hat_offset;
            if( posicion < 0 )
                posicion = 0;
            if( posicion > d.height-hat_high )
                posicion = d.height-hat_high;
            update();
            }
        if( boolDrag && orientacion == 1 )
            {
            posicion = x-hat_offset;
            if( posicion < 0 )
                posicion = 0;
            if( posicion > d.width-hat_high )
                posicion = d.width-hat_high;
            update();
            }
        return( true );
        }


    public boolean handleEvent( Event evt ) {
        Event evnt;

        switch( evt.id ) {
            case 501:
                return( onMouseDown( evt.x,evt.y ) );
            case 502:
                evnt = new Event( this,1001,new Integer( valor ) );
                break;
            case 506:
                return( onMouseDrag( evt.x,evt.y ) );
            default:
                return( false );
            }
        postEvent( evnt );
        boolDrag = false;
        return( true );
        }

    public void reshape( int x,int y,int w,int h ) {
        super.reshape( x,y,w,h );
        offscreen = createImage( w,h );
        update();
        }

    public Dimension preferredSize() {
        return( minimumSize() );
        }

    public Dimension minimumSize() {
        return( new Dimension( 40,40 ) );
        }

    // Pintamos un triangulito sobre el indicador, que apunta hacia
    // donde se encuentra la escala que estamos usando
    private void drawTriangulo( Graphics g,int x,int y,
        int tam,int orient,boolean habil ) {
        if( habil )
            g.setColor( Color.black );
        else
            g.setColor( Color.gray );
        for( int i=0; i < tam; i++ )
            {
            switch( orient ) {
                case 3:
                    g.drawLine( x+i,y-i,x+2*tam-i-1,y-i );
                    break;
                case 4:
                    g.drawLine( x+i,y+i,x+2*tam-i-1,y+i );
                    break;
                case 1:
                    g.drawLine( x-i,y+i,x-i,y+2*tam-i-1 );
                    break;
                case 2:
                    g.drawLine( x+i,y+i,x+i,y+2*tam-i-1 );
                    break;
                }
            }
        }

    static {
        defFuente = new Font( "Dialog",0,16);
        }
    }

//------------------------------------- Final del fichero Potenciometro.java
