//  
//  RelojDigital.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Jun-1996  05:18:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.lang.*;
import java.util.*;
import java.applet.*;

public class RelojDigital extends Applet implements Temporizador {
    private Timer timer;
    private Etiqueta horaActual;
    private Color fondo;

    // Este es el metodo main() para que podamos ejecutar la aplicacion
    // desde la linea de comandos
    public static void main( String args[] ) {
        RelojDigital reloj = new RelojDigital();

        reloj.init();
        reloj.start();
      
        // Craemos un frame para que se pueda visualizar el reloj
        Frame frame = new Frame( "Reloj Digital" );
        frame.add( "Center",reloj );
        frame.resize( 50,20 );
        frame.show();
        }   
      

    public void init() { 
        // Cargamos el parametro que nos indica el color de fondo que
        // queremos para el reloj, si no se especifica o no se indica
        // correctamente, fijamos uno por defecto
        // Lo adecuado, en caso de presentar el applet sobre una pagina
        // de un navegador es que este parametro coincida con el que
        // se especifique para el color de Background de esa pagina
        String Fondo = getParameter( "Fondo" );
        if( Fondo == null )
             fondo = Color.lightGray;
        else
            {
            try {
                fondo = new Color( Integer.parseInt( Fondo,16 ) );
            } catch( NumberFormatException e ) {
                fondo = Color.lightGray;
                }
            }
        setBackground( fondo );

        // Nos creamos un timer, para actualizar el reloj cada segundo
        Timer timer = new Timer( this );         

        // Creamos un objeto Etiqueta, para que nuestro reloj aparezca
        // con un texto decente y bonito
        horaActual = new Etiqueta();
        horaActual.setFont( "Helvetica",Font.PLAIN,18 );
        horaActual.setColor( new Color( 128,0,0 ) );
        horaActual.setAlto( 25 );
        horaActual.setAncho( 100 );
        horaActual.setSombra( Etiqueta.TextoHundido );
        horaActual.setBorde( true );
        add( horaActual );

        // Arrancamos el timer para que el reloj empiece a marchar
        timer.start();
        }   

  
    // En cada aviso de que nuestro Timer ha llegado al intervalo de
    // tiempo que nosotros hemos fijado, cogemos la hora del sistema 
    // y la presentamos
    public void timerIntervalo( Timer t ) {
        Date actual = new Date();
        int horas = actual.getHours();
        int minutos = actual.getMinutes();
        int segundos = actual.getSeconds();
        int hora;
        String tiempo = "";

        // Los "ifs" que siguen son para formatear la hora
        // correctamente y que siempre ocupe lo mismo en la
        // Etiqueta, para que no salten las horas de posicion al
        // presentarse en pantalla
        if( horas > 12 ) 
            hora = horas - 12;
        else
            hora = horas;
        if( hora < 10 )
            tiempo += "0";
        tiempo += hora;
        tiempo += ":";

        if( minutos < 10 )
            tiempo += "0";
        tiempo += minutos + ":";

        if( segundos < 10 )
            tiempo += "0";
        tiempo += segundos;

        if( horas > 12 )
            tiempo += " pm";
        else
            tiempo += " am";

        horaActual.setText( tiempo );
        }


    // Sobrecargamos los metodos que no nos interesan de la interface
    // Temporizador, porque solamente vamos a utilizar la que genera
    // un evento cada cierto intervalo de tiempo, las demas no tienen
    // interes en este ejemplo
    public void timerArrancado( Timer t ) { }

    public void timerParado( Timer t ) { }
      
    public void timerMuerto( Timer t ) { }


    public void paint( Graphics g ) {
        g.setColor( fondo );
        g.fillRect( 0,0,size().width,size().height );
        }
    }
      
//-------------------------------------- Final del fichero RelojDigital.java
