//  
//  Solapa.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 12-Sep-1996  11:57:07
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Este objeto se utiliza para seleccionar cada una de las fichas
// Pulsando con el raton sobre una de ellas, se visualizara el
// contenido de la ficha que tiene adosada
public class Solapa extends Canvas {
    protected String rotulo;      // Rotulo indicador de la solapa
    protected Font seleFont;      // Font cuando la solapa esta seleccionada
    protected Font normFont;      // Font del estado normal de la solapa
    protected boolean seleccionada; // Indicador de seleccion de la solapa

    public Solapa( String rotulo,Font normFont,
        Font seleFont,Color captionColor,Color bgColor ) {
        super();
        this.rotulo = rotulo;
        this.normFont = normFont;
        this.seleFont = seleFont;
        setForeground( captionColor );
        setBackground( bgColor );
        seleccionada = false;
        }


    public void pintaRotulo( Graphics g ) {
        int rotuloX;
        int rotuloY;
        FontMetrics fm;

        // Comprobamos la fuente de caracteres que vamos a utilizar en la
        // presentacion del rotulo, en funcion del estado de la ficha
        if( seleccionada ) 
            {
            g.setFont( seleFont );
            fm = g.getFontMetrics( seleFont );
            } 
        else 
            {
            g.setFont( normFont );
            fm = g.getFontMetrics( normFont );
            }

        // Calculamos las coordenadas en que vamos a presentar el rotulo
        // Teniendo en cuenta la longitud del texto del rotulo y
        // la fuente de caracteres
        rotuloX = 
            bounds().x +( (bounds().width - fm.stringWidth(rotulo) ) / 2);
        rotuloY = bounds().y + ( bounds().height / 2 ) - 
            fm.getDescent() + ( fm.getHeight() / 2 );

        // Fijamos el color y pintamos el rotulo
        g.setColor( getForeground() );
        g.drawString( rotulo,rotuloX,rotuloY );
        }


    // Pinta la solapa en base a pares de lineas para proporcionar
    // sensacion de tres dimensiones, en caso de que este seleccionada
    // se pintara dos pixels mas grande para que de la sensacion
    // de que esta delante del resto de fichas
    public void pintaSolapa( Graphics g ) {
        int delante;
        Rectangle area;

        delante = ( seleccionada ) ? 2 : 0;
        area = bounds();
        g.setColor( getBackground() );

        // Pintamos el rectangulo que va a ocupar la solapa
        if ( !seleccionada ) 
            {
            g.fillRect( area.x,area.y+2, area.width,area.height-2 );
            g.drawLine( area.x+1,area.y+1,area.width+area.x-2,area.y+1 );
            } 
        else 
            {
            g.fillRect( area.x-1,area.y,area.width+2,area.height );
            g.drawLine( area.x,area.y-1,area.x+area.width,area.y-1 );
            }

        // left side, rounded corner and top side lit
        g.setColor( Color.white );
        g.drawLine( area.x-delante,area.y+area.height-2,
            area.x-delante,area.y+2-delante );
        g.drawLine( area.x-delante,area.y+2-delante,
            area.x+2-delante,area.y-delante );
        g.drawLine( area.x+2-delante,area.y-delante,
            area.x+area.width-2+delante,area.y-delante );

        if( !seleccionada ) 
            {
            // Pintamos la sombra del lado derecho
            g.setColor( Color.gray );
            g.drawLine( area.x+area.width-1,area.y,
                area.x+area.width-1,area.y+area.height-2 );

            // Pintamos la sombra de la sombra del lado derecho
            // para dar mas sensacion de profundidad
            g.setColor( Color.black );
            g.drawLine( area.x+area.width,area.y+2,
                area.x+area.width,area.y+area.height-2 );
            } 
        else 
            {
            // Pintamos la sombra del lado derecho
            g.setColor( Color.gray );
            g.drawLine( area.x+area.width-1+delante,area.y-delante,
                area.x+area.width-1+delante,area.y+area.height-2 );

            // Pintamos la sombra de la sombra del lado derecho
            g.setColor( Color.black );
            g.drawLine( area.x+area.width+delante,area.y+2-delante,
                area.x + area.width+delante,area.y + area.height-2 );

            // Como la solapa esta seleccionada, pintamos en color del
            // fondo la linea que une la solapa anterior con la 
            // siguiente, dando sensacion de que la solapa esta
            // efectivamente pegada a la ficha
            g.setColor( getBackground() );
            g.drawLine( area.x-delante+1,area.y+area.height,
                area.x+area.width,area.y+area.height );
            }
        }


    // Devuelve el texto del rotulo de la solapa
    public String getRotulo() {
        return( rotulo ); 
        }


    // Devuelve el punto correspondiente a la posicion final de la
    // solapa
    public Point getFinal() {
        return( new Point(bounds().x+bounds().width+2,bounds().y ) );
        }


    // Devuelve la altura de la solapa
    public int getAlto() {
        return( size().height );
        }


    // Devuelve la fuente de caracteres con que se pinta el rotulo de
    // la solapa cuando esta seleccionada
    public Font getFuenteSel() {
        return( seleFont );
        }


    // Indica si la posicion que se pasa como parametro esta dentro
    // de los limites de la solapa o no
    public boolean estaDentro( int x,int y ) {
        return( bounds().inside( x,y ) );
        }


    // Indica si la solapa esta seleccionada o no
    public boolean estaSeleccionada() {
        return( seleccionada );
        }


    // Cuando pulsamos el raton, nos devuelve true si lo hemos hecho
    // sobre la solapa o false si lo hemos hecho fuera del rectangulo
    // que ocupa la solapa
    public boolean mouseDown( Event evt,int x,int y ) {
        if( ( estaDentro( x,y ) ) && ( !estaSeleccionada() ) )
            return( true );
        else 
            return( false );
        }


    public void paint( Graphics g ) {
        pintaSolapa( g );
        pintaRotulo( g );
        }


    // Indica que la solapa esta seleccionada
    public void seleccionar() {
        seleccionada = true;
        }


    // Indica que la solapa deja de estar seleccionada
    public void deSeleccionar() {
        seleccionada = false;
       }
    }

//-------------------------------------------- Final del fichero Solapa.java
