//  
//  Habitacion.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 22-Oct-1996  11:37:12
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

// Esta clase es realmente un objeto muy simple que usaremos para
// poder levantar nuestro Hotel
public class Habitacion {
    private int numHabitacion;
    private int numCamas;

    // Constructor basico, inicializa todos los datos miembros
    public Habitacion() {
        habitacion( 0 );
        camas( 2 );
        }

    // Constructor de conveniencia, inicializa la habitacion con
    // un numero determinado
    public Habitacion( int numeroHab ) {
        habitacion( numeroHab );
        camas( 2 );
        }

    // Constructor de conveniencia, inicializa la habitacion con
    // un numero determinado y con una cantidad de camas dada
    public Habitacion( int numeroHab,int camas ) {
        habitacion( numeroHab );
        camas( camas );
        }

    // Este metodo devuelve el numero de la habitacion
    public synchronized int habitacion() {
        return( numHabitacion );
        }

    // Este metodo le asigna a la habitacion un numero
    public synchronized void habitacion( int numeroHab ) {
        numHabitacion = numeroHab;
        }

    // Este metodo devuelve el numero de camas de una habitacion
    public synchronized int camas() {
        return( numCamas );
        }

    // Este metodo asigna un numero de camas determinado a una habitacion
    public synchronized void camas( int camas ) {
        numCamas = camas;
        }

    // Este metodo imprime los datos de una habitacion, numero y camas
    public synchronized void printData() {
        System.out.println( "Habitacion #"+numHabitacion+": "+
            numCamas+" camas" );
        }
    }

//---------------------------------------- Final del fichero Habitacion.java
