//  
//  Hotel3.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 22-Oct-1996  15:01:15
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import Habitacion;
import ListaEnlazada;

// Aqui tenemos otra demostracion, en este caso utilizamos para
// levantar nuestro Hotel las referencias Java y estructuras 
// de datos complejas, como la Lista Doblemente Enlazada
public class Hotel3 {
    // Numero de habitaciones en cada ala del Hotel
    public static final int habPorAla = 12;

    public static void main( String args[] ) {
        // Creamos el llavero para guardar todas las llaves
        // de las habitaciones
        // Comenzamos con un ala simple sobre un solo piso que
        // contiene 12 habitaciones
        ListaEnlazada llaveMaestra;
        llaveMaestra = new ListaEnlazada();

        // Ahora, creamos cada una de las habitaciones y guardamos
        // su llave en el llavero maestro
        int pisoNum = 1;
        for( int i=0; i < habPorAla; i++ )
            {
            // Los numeros de las habitaciones se dan en miles para que
            // al imprimir quede mas bonito. Las habitaciones pares las
            // ponemos con 1 cama y las impares con 2 camas
            llaveMaestra.insertAt( i,new Habitacion( pisoNum * 1000 + i,
                ( 0 == (i % 2)) ? 2 : 1 ) );
                }
	
        // Imprimimos los datos, para ver lo que hemos hecho
        for( int i=0; i < habPorAla; i++ )
            ( (Habitacion)llaveMaestra.getAt(i) ).printData();
        }
    }

//-------------------------------------------- Final del fichero Hotel3.java

