//  
//  ListaEnlazada.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Jun-1996  05:18:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import NodoListaEnlazada;

// Aqui tenemos la implementacion de una lista enlazada desordenada
// Al igual que con el nodo, si se quiere utilizar en proyectos de
// mas envergadura, habria que dotarla de comprobacion y manejo de
// errores, borrato, iteracion... Es decir, que eso solo sirve como
// ejemplo y para nuestra pequena y simple aplicacion; no debe
// usarse, tal como esta, para nada mas
public class ListaEnlazada {
    // Usaremos un nodo 'dummy' para controlar el principio y final
    // de la lista doblemente enlazada que estamos implementando,
    // lo que nos simplifica bastante las cosas
    public NodoListaEnlazada PrincipioFin;

    // Mantenemos un contador del numero de nodos en la lista
    private int numNodos;

    // Constructor basico
    public ListaEnlazada() {
        // Inicialmente, no hay ningun nodo
        numNodos = 0;

        // Creamos nuestro nodo dummy
        PrincipioFin = new NodoListaEnlazada();

        // Hacemos que los apuntadores del nodo dummy lo hagan a
        // si mismo, incluso que sus datos se refieran a los suyos
        PrincipioFin.insertEntre( PrincipioFin,PrincipioFin,PrincipioFin );
        }


    // Acceso al numero de nodos
    public int longitud() {
        return( numNodos );
        }


    // Modificacion del numero de nodos
    private protected void incLongitud() {
        numNodos++;
        }


    private protected void decLongitud() {
        numNodos--;
        }


    // Insertamos los datos que nos indiquen como nueva cabecera
    // de la lista
    public void insertAtHead( Object datos ) {
        NodoListaEnlazada nuevoNodo;

        nuevoNodo = new NodoListaEnlazada();
        nuevoNodo.insertDespues( PrincipioFin,datos );
        incLongitud();
        }
    

    // Insertamos los datos que nos indiquen al final de la lista
    public void insertAlFinal( Object datos ) {
        NodoListaEnlazada nuevoNodo;

        nuevoNodo = new NodoListaEnlazada();
        nuevoNodo.insertAntes( PrincipioFin,datos );
        incLongitud();
        }


    // Insertamos los datos en la posicion que nos digan, o al
    // final de la lista en caso de que no sea tan larga como
    // indique el indice
    public void insertAt( int indice,Object datos ) {
        // Comprobamos que la lista tenga suficientes nodos
        if( longitud() < indice )
            {
            // Si no los tiene, insertamos al final
            insertAlFinal( datos );
            }
        else
            {
            NodoListaEnlazada tempNodo;
            NodoListaEnlazada nuevoNodo;

            // Vamos saltando de nodo en nodo hasta llegar al indicado
            tempNodo = PrincipioFin;
            for( int i=0; i < indice; i++ )
                tempNodo = tempNodo.siguiente();

            // Creamos un nuevo nodo en esa posicion y lo incorporamos a
            // la lista
            nuevoNodo = new NodoListaEnlazada( tempNodo,
                tempNodo.siguiente(),datos );
            incLongitud();
            }
        }


    // Recupera los datos de un determinado nodo (o del ultimo elemento
    // si la lista no tiene tantos nodos), o devuelve null si la
    // lista esta vacia
    public Object getAt( int indice ) {
        // Comprobamos si la lista tiene tantos nodos como indica el indice
        if( longitud() < indice )
            {
            // Comprobamos que la lista no este vacia
            if( longitud() == 0 )
                // La lista esta todavia vacia
                return( null );
            else
                return( PrincipioFin.anterior() );
            }
        else
            {
            // Estamos dentro del rango de la lista
            NodoListaEnlazada tempNodo;

            // Vamos saltando por los nodos hasta alcanzar el pedido
            tempNodo = PrincipioFin.siguiente();
            for( int i=0; i < indice; i++ )
                tempNodo = tempNodo.siguiente();
            // Devolvemos los datos de ese nodo
            return( tempNodo.datos() );
            }
        }
    }

//------------------------------------- Final del fichero ListaEnlazada.java
