//  
//  NodoListaEnlazada.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Jun-1996  05:18:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

// Aqui implementamos una Lista Enlazada muy simple.
// Para usarla en serio habria que implementar un control
// de los errores que se pudiesen producir y la posibilidad
// de borrar nodos, que no se ha hecho porque, en principio,
// no lo necesitamos
public class NodoListaEnlazada {
    // Referencias al nodo anterior y posterior en la lista
    private NodoListaEnlazada nodoSiguiente;
    private NodoListaEnlazada nodoAnterior;

    // Referencia a los datos actuales del objeto
    // Esto no funcionaria con tipos basicos, porque no
    // se pueden pasar como objetos
    private Object nodoDatos;

    // Constructor Basico
    public NodoListaEnlazada() {
        // Reseteamos los apuntadores
        siguiente( null );
        anterior( null );

        // En principio, no hay datos
        datos( null );
        }


    // Construimos un nuevo nodo y lo insertamos en medio
    // de los dos que nos indiquen
    public NodoListaEnlazada( NodoListaEnlazada antes,
        NodoListaEnlazada despues,Object datos ) {
        insertEntre( antes,despues,datos );
        }


    // Inserta un nodo entre dos determinados
    public void insertEntre( NodoListaEnlazada antes,
        NodoListaEnlazada despues,Object datos ) {
        // Fijamos nuestros apuntadores
        anterior( antes );
        siguiente( despues );

        // Fijamos los apuntadores de los otros nodos a nosotros
        antes.siguiente( this );
        despues.anterior( this );

        // Fijamos los datos del nodo
        datos( datos );
        }


    // Inserta un nodo antes del que nos indiquen
    public void insertAntes( NodoListaEnlazada despues,Object datos ) {
        // Fijamos nuestros apuntadores
        anterior( despues.anterior() );
        siguiente( despues );

        // Fijamos los apuntadores de los otros nodos a nosotros
        anterior().siguiente( this );
        despues.anterior( this );

        // Fijamos los datos del nodo
        datos( datos );
        }


    // Inserta un nodo despues del que nos indiquen
    public void insertDespues( NodoListaEnlazada antes,Object datos ) {
        // Fijamos nuestros apuntadores
        anterior( antes );
        siguiente( antes.siguiente() );

        // Fijamos los apuntadores de los otros nodos a nosotros
        antes.siguiente( this );
        siguiente().anterior( this );

        // Fijamos los datos del nodo
        datos( datos );
        }


    // Acceso a los elementos de un nodo
    public NodoListaEnlazada anterior() {
        return( nodoAnterior );
        }


    public NodoListaEnlazada siguiente() {
        return( nodoSiguiente );
        }


    public Object datos() {
        return( nodoDatos );
        }
    

    // Modificacion de los elementos de un nodo
    public void anterior( NodoListaEnlazada nodo ) {
        nodoAnterior = nodo;
        }


    public void siguiente( NodoListaEnlazada nodo ) {
        nodoSiguiente = nodo;
        }


    public void datos( Object datos ) {
        nodoDatos = datos;
        }
    }

//--------------------------------- Final del fichero NodoListaEnlazada.java

