//  
//  AplicacionAWT.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 08-Jul-1996  06:21:30
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

public class AplicacionAWT extends Frame {
    // Fijamos el tamao de la ventana mediante variables "finales" que
    // deben ser constantes
    static final int HOR_TAMANO = 350;
    static final int VER_TAMANO = 200;
    private MenuBar mbarra;

    public AplicacionAWT() {
        // Ponemos el rotulo a la ventana
        super( "Aplicacin Java con AWT" );

        // Creamos los menus
        InicializaMenus();

        setFont( new Font( "TimesRoman",Font.PLAIN,12 ) );
        setBackground( Color.white );
        setForeground( Color.black );
        setLayout( new BorderLayout() );
        
        // Incorporamos dos botones en la parte inferior de la
        // ventana
        Panel p = new Panel();
        p.add( new Button( "Aceptar" ) );
        p.add( new Button( "Cancelar" ) );
        add( "South",p );

        // Ajustamos el tamao de la ventana a nuestras necesidades
        // y la hacemos visible en pantalla
        pack();
        resize( HOR_TAMANO,VER_TAMANO );
        show();
        }

    // Creamos la barra de mens y las opciones que se
    // abrirn cuando se seleccione cada una de ellas
    private void InicializaMenus() {
        mbarra = new MenuBar();

        // Opcion Archivo del menu y las subopciones
        Menu m = new Menu( "Archivo" );
        m.add( new MenuItem( "Nuevo" ) );
        m.add( new MenuItem( "Abrir" ) );
        m.add( new MenuItem( "Guardar" ) );
        m.add( new MenuItem( "Guardar como" ) );
        m.add( new MenuItem( "Imprimir" ) );
        m.addSeparator();
        m.add( new MenuItem( "Salir" ) );
        mbarra.add( m );

        // Opcion Ayuda del menu y subopciones
        m = new Menu( "Ayuda" );
        m.add( new MenuItem( "Ayuda!" ) );
        m.addSeparator();
        m.add( new MenuItem( "Acerca de..." ) );
        mbarra.add( m );

        setMenuBar( mbarra );
        }


    public void paint( Graphics g ) {
        g.setFont( new Font( "TimesRoman",Font.BOLD,24 ) );
        g.setColor( Color.blue );
        g.drawString( getTitle(),30,50 );
        }


    public boolean handleEvent( Event evt ) {
        switch( evt.id ) {
            // Aqu controlamos el evento de destruccion de la
            // ventana
            case Event.WINDOW_DESTROY:
                System.exit( 0 );
                return true;
            // Cuando se selecciona alguna de las opciones del
            // Menu, simplemente se imprime en la consola el texto
            // indicativo de la opcion seleccionada
            case Event.ACTION_EVENT: 
                if( evt.target instanceof MenuItem ) 
                    {
                    if( "Nuevo".equals( evt.arg ) ) 
                        AplicacionAWT aAwt = new AplicacionAWT();;
                    if( "Abrir".equals( evt.arg ) ) 
                        System.out.println( "Opcion -Abrir-" );
                    if( "Guardar".equals( evt.arg ) ) 
                        System.out.println( "Opcion -Guardar-" );
                    if( "Guardar como".equals( evt.arg ) ) 
                        System.out.println( "Opcion -Guardar como-" );
                    if( "Imprimir".equals( evt.arg ) ) 
                        System.out.println( "Opcion -Imprimir-" );
                    if( "Salir".equals( evt.arg ) ) 
                        System.exit( 0 );
                    if( "Ayuda!".equals( evt.arg ) ) 
                        System.out.println( "No hay ayuda disponible" );
                    if( "Acerca de...".equals( evt.arg ) ) 
                        {       
                        AboutDialog ad = new AboutDialog( this );
                        ad.move(400,560);
                        ad.show();
                        }
                    }
            default:
                return false;
            }
        }

    // Main para generar la aplicacion
    public static void main( String args[] ) {
        new AplicacionAWT();
        }
    }


// Clase para presentar la ventana Acerca de...
class AboutDialog extends Dialog {
    static int HOR_TAMANO = 300;
    static int VER_TAMANO = 150;
    
    // Constructor de la clase, que presenta una ventana con informacion
    // y un boton pasa ocultarla
    public AboutDialog( Frame parent ) {
        super( parent,"Acerca de...",true );
        this.setResizable( false );
        setBackground( Color.gray );
        setLayout( new BorderLayout() );

        Panel p = new Panel();
        p.add( new Button( "Aceptar" ) );
        add( "South",p );
        resize( HOR_TAMANO,VER_TAMANO );
        }

    // Presentamos informacin de la aplicacin cuando se 
    // selecciona la opcion de Acerca de...
    public void paint( Graphics g ) {
        g.setColor( Color.white );
        g.drawString( "Aplicacin Java con AWT",HOR_TAMANO/4,VER_TAMANO/3 );
        g.drawString( "Versin 1.00",HOR_TAMANO/3+15,VER_TAMANO/3+20 );
        }


    public boolean handleEvent( Event evt ) {
        switch( evt.id ) {
            // Solo manejamos el evento del boton Aceptar,
            // y lo que ahcemos es ocultar la ventana
            case Event.ACTION_EVENT:
                if( "Aceptar".equals( evt.arg ) ) 
                    {
                    hide();
                    return true;
                    }
            default: 
                return false;
            }
        }
    }
        
//------------------------------------- Final del fichero AplicacionAWT.java
