//  
//  AwtCard.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 25-Jul-1996  19:39:31
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Demostracion del uso del CardLayout
public class AwtCard extends Applet {
    Panel card;
    final static String PanelBoton = "Panel con Botones";
    final static String PanelTexto = "Panel con Campo de Texto";

    public void init() {
        // en la zona de seleccion del CardLayout, creamos un panel
        // con una lista de seleccion que nos permita seleccionar
        // entre dos paneles diferentes en la zona de visualizacion
        setLayout( new BorderLayout() );
        Panel ac = new Panel();
        Choice c = new Choice();

        c.addItem( PanelBoton );
        c.addItem( PanelTexto );
        ac.add( c );
        add( "North",ac );

        card = new Panel();
        card.setLayout( new CardLayout() );

        // Uno de los paneles de la zona de visualizacion solo va a 
        // contener botones
        Panel p1 = new Panel();
        p1.add( new Button( "Botn 1" ) );
        p1.add( new Button( "Botn 2" ) );
        p1.add( new Button( "Botn 3" ) );
        
        // El otro panel, contendra un campo de texto de 20 columnas
        Panel p2 = new Panel();
        p2.add( new TextField( "Texto",20 ) );

        // Incorporamos los paneles de visualizacion al Layout
        card.add( PanelBoton,p1 );
        card.add( PanelTexto,p2 );
        add( "Center",card );
        }


    // Solo manejamos el evento de la lista de seleccion, en funcion
    // de la opcion elegida presentara uno u otro de los paneles
    public boolean action( Event evt,Object arg ) {
        if( evt.target instanceof Choice ) 
            {
            ( (CardLayout)card.getLayout() ).show( card,(String)arg );
            return true;
            }
        return false;
        }
    }

//------------------------------------------- Final del fichero AwtCard.java
