//  
//  AwtGui.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 25-Jul-1996  19:55:42
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.util.*;
import java.io.*;
import java.applet.Applet;

// Clase para pintar casi todos los componentes que ofrece el AWT
// de Java y poder visualizar su apariencia en la pantalla
public class AwtGui extends Applet {
    TextArea edicion;
    miCanvas dibujo;
    Label edicionLab,lapizLab;
    List colores;
    Button imprimir,borrar;
    Choice figuras;
    Checkbox relleno;
    Scrollbar lapizBar;
    TextField lapizTex;
    Panel panelIzq,panelDch,panelBot,panelDib;

    public void init() {
        // Creamos los paneles con sus layout managers
        panelIzq = new Panel();
        panelIzq.setLayout( new BorderLayout() );
        
        panelDch = new Panel();
        panelDch.setLayout( new BorderLayout() );

        panelBot = new Panel();
        panelBot.setLayout( new GridLayout( 4,0 ) );
        
        panelDib = new Panel();
        panelDib.setLayout( new BorderLayout() );
        panelDib.reshape( 1,1,200,20 );

        // Construimos el lado izquierdo de la ventana
        // Creamos la lista de colores
        colores = new List( 6,false );
        colores.addItem( "Rojo" );
        colores.addItem( "Naranja" );
        colores.addItem( "Amarillo" );
        colores.addItem( "Verde" );
        colores.addItem( "Azul" );
        colores.addItem( "Morado" );
        colores.addItem( "Negro" );
        colores.addItem( "Blanco" );
        // Aadimos la lista de colores al panel izquierdo
        panelIzq.add( "West",colores );

        // Creamos un nuevo Canvas
        dibujo = new miCanvas();
        dibujo.reshape( 0,0,100,100 );
        // Aadimos el canvas al panel izquierdo
        panelIzq.add( "Center",dibujo );

        // Creamos los botones
        borrar = new Button( "Borrar" );
        imprimir = new Button( "Imprimir" );
        figuras = new Choice();
        figuras.addItem( "Cuadrado" );
        figuras.addItem( "Crculo" );
        figuras.addItem( "Tringulo" ); 
        relleno = new Checkbox( "Relleno" );
        // Aadimos los botones a su propio panel
        panelBot.add( borrar );
        panelBot.add( imprimir );
        panelBot.add( figuras );
        panelBot.add( relleno );
        // Aadimos el panel de botones al lado derecho
        panelIzq.add( "East",panelBot );

        // Creamos el area del lpiz
        lapizLab = new Label( "Lpiz" );
        lapizBar = new Scrollbar( Scrollbar.HORIZONTAL,1,1,1,10 );
        lapizBar.reshape( 1,1,100,5 );
        lapizTex = new TextField( "1",8 );
        // Aadimos las partes anteriores a su propio panel
        panelDib.add( "North",lapizLab );
        panelDib.add( "Center",lapizBar );
        panelDib.add( "East",lapizTex );
        // Aadimos el panel a la parte inferior
        panelIzq.add( "South",panelDib );

        // Construimos el lado derecho de la ventana
        edicionLab = new Label( "Editor" );
        edicion = new TextArea( "Aqui se puede escribir",8,30 );
        // Aadimos la etiqueta y el rea de texto al lado derecho
        panelDch.add( "North",edicionLab );
        panelDch.add( "South",edicion );

        // Incorporamos los dos paneles al applet que utiliza
        // FlowLayout por defecto
        add( panelIzq );
        add( panelDch );
        }
    }


// Creamos una clase para poder pintar una zona de dibujo y que
// se muestre el canvas. Pintamos un rectangulo alrededor suyo
class miCanvas extends Canvas {
    public void paint( Graphics g ) {
        int w = size().width;
        int h = size().height;
        g.drawRect( 0,0,w-1,h-1 );
        g.drawString( "Canvas",
            ( w-g.getFontMetrics().stringWidth( "Canvas" ) )/2,10 );
        }
    }  
     
//------------------------------------------- Final del fichero AwtGui.java
