//  
//  BotonGrafico.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 11-Ago-1996  15:54:01
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Los tres graficos que corresponden a los estados del boton se pasan
// en la llamada al applet, y se corresponden con:
// IMAGEN0    - Boton deshabilitado, o cursor fuera del applet
// IMAGEN1    - Boton en estado normal y activo
// IMAGEN2    - Boton pulsado
//
public class BotonGrafico extends Applet {
    private MediaTracker tracker;
    private Image imagen[] = new Image[3];
    private boolean BotActivo = false;
    private boolean BotPulsado = false;
    private boolean tresImg = false;
    private int Estado = 0;


    public void init() {
        String istr;
        tracker = new MediaTracker( this );
  
        // Recogemos las tres imagenes de los paramentros de llamada
        // al applet
        for( int i=0; i < 3; i++ ) 
            {
            istr = getParameter( "IMAGEN" + i );
            if( istr == null )
                tresImg = false;
            else
                {
                // Registramos las imagenes con el Media Tracker
                imagen[i] = getImage( getCodeBase(),istr );
                tracker.addImage( imagen[i],0 );
                try {
                    tracker.waitForAll();
                    } 
                catch( InterruptedException e ) {
                    System.out.println( "Error cargando imagen " + i );
                    }
                }
            }
        }


    public void start() {
        repaint();
        }


    public void stop(){
        }

                                       
    // Controlamos la pulsacion del raton
    public boolean mouseDown( Event evt,int x,int y ) {
        BotPulsado = true;
        repaint();

        return( true );
        }

         
    // Controlamos cuando el usuario suelta el boton del raton
    public boolean mouseUp( Event evt,int x,int y ) {
        if( BotPulsado && BotActivo )
            {
            BotPulsado = true;
            repaint();
            }
        else
            {
            BotPulsado = false;
            repaint();
            }
        return( true );
        }

                                     
    // Controlamos cuando el cursor del raton entra en el
    // campo de accion del applet
    // Presentamos un mensaje en la linea de estado
    public boolean mouseEnter( Event evt,int x,int y ) {
        BotActivo = true;
        showStatus( "Tutorial de Java, Boton Grafico" );
        repaint();

        return( true );
        }

                                                   
    // Controlamos cuando el cursor del raton abandona el
    // lugar ocupado por el applet
    public boolean mouseExit( Event evt,int x,int y ) {
        BotActivo = false;
        showStatus( "" );
        repaint();

        return( true );
        }


    public void update( Graphics g ) {
        // Controlamos el estado en que se queda el boton
        // tras la accion que se haya hecho con el raton
        if( !BotActivo )
            Estado = 0;
        else 
            if( BotActivo && !BotPulsado )
                Estado = 1;
            else
                Estado = 2;

        paint( g );
        }


    public void paint( Graphics g ) {
        g.drawImage( imagen[Estado],0,0,this );
        }
    }

//-------------------------------------- Final del fichero BotonGrafico.java
