//  
//  CambioBoton.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 26-Ago-1996  19:31:13
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Creamos la clase Boton Variable, en donde lo nico que sobrecargamos
// es el constructor normal de la clase Button, para que nos permita
// variar el tamao del botn
class BotonVariable extends Button {    
    private Dimension dim = null;

    public BotonVariable( String str,Dimension dim ) {
        super( str );
        this.dim = new Dimension( dim );
        resize( dim );
        }

    // Mtodo que hace efectivo el cambio de dimensiones del botn
    public void newPreferredSize( Dimension dim ) {
        this.dim = new Dimension( dim );
        resize( dim );
        }

    // Mtodo que nos devuelve la dimensin actual del botn
    public Dimension preferredSize() {
        return( new Dimension( dim ) );
        }
    }


// Demostracin del uso del botn variable que hemos definido antes
public class CambioBoton extends Applet {
    private BotonVariable bv1 = null;
    private BotonVariable bv2 = null;
    public void init() {
        setLayout( new FlowLayout() );
        setBackground( Color.cyan );
        Dimension dim = new Dimension( 85,30 );

        // Creamos dos botones, y lo que haremos ser que cuando se
        // pulse en uno se haga ms grande o ms chico que el otro
        // y este segundo al contrario
        bv1 = new BotonVariable( " Plsame",dim );
        bv2 = new BotonVariable( " No, Plsame",dim );
        add( bv1 );
        add( bv2 );
        }

    // Colocamos los botones con un borde amplio
    public Insets insets() {
        return( new Insets( 30,10,10,10 ) );
        } 

    public Dimension preferredSize() {
        return( new Dimension( 200,100 ) );
        }

    public boolean action( Event evt,Object obj ) {
        Dimension dim1 = bv1.preferredSize();
        Dimension dim2 = bv2.preferredSize();

        // Controlamos que el botn que aumenta de tamao sea el que se
        // ha pulsado, y el otro disminuya
        if( evt.target == bv1 )
            {
            dim1.width++;
            dim1.height++;
            dim2.width--;
            dim2.height--;
            }
        else if( evt.target == bv2 )
            {
            dim2.width++;
            dim2.height++;
            dim1.width--;
            dim1.height--;
            }

        // Controlamos que las dimensiones no se hagan tan pequeas
        // que no llegue a verse nada
        if( dim1.width < 1 ) 
            dim1.width = 1;
        if( dim1.height < 1 ) 
            dim1.height = 1;
        if( dim2.width < 1 ) 
            dim2.width = 1;
        if( dim2.height < 1 ) 
            dim2.height = 1;

        bv1.newPreferredSize( dim1 );
        bv2.newPreferredSize( dim2 );
        // Regeneramos el contenido del layout
        layout();

        // Propagamos el evento a la ventana para que se refresque
        return( super.action( evt,obj ) );
        }


    public static void main( String args[] ) {
        Frame fr = new Frame( "Botones Variables" );
        CambioBoton cb = new CambioBoton();
        cb.init();
        fr.add( "Center",cb );
        fr.pack();
        fr.show();
        }
    }

//--------------------------------------- Final del fichero CambioBoton.java
