//  
//  Cascada.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 21-Ago-1996  20:08:32
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Implementacin de una clase que nos permite anidar mens de forma que se
// vayan abriendo en funcin de opciones seleccionadas en el men anterior
public class Cascada extends Frame {

    // Constructor
    public Cascada() {
        MenuBar menub;
        Menu menu;
        Menu cMenu1;
        Menu cMenu2;

        // Fijamos el ttulo de la ventana
        setTitle( "Mens en Cascada" );

        // Barra de men principal de la aplicacin
        menub = new MenuBar();

        // Primer elemento desde el men principal
        menu = new Menu( "Archivo" );

        // Primer desdendiente de "Archivo", que es otro men
        cMenu1 = new Menu( "Abrir" );
        cMenu1.add( new MenuItem( "Nuevo" ) );
        cMenu1.add( new MenuItem( "Plantilla" ) );
        menu.add( cMenu1 );

        // Segundo descendiente que ser otro men en cascada
        cMenu1 = new Menu( "Imprimir" );

        cMenu2 = new Menu( "Archivo" );
        cMenu2.add( new MenuItem( "Guardar" ) );
        cMenu2.add( new MenuItem( "Guardar como" ) );
        cMenu2.add( new MenuItem( "Borrar" ) );
        cMenu1.add( cMenu2 );

        cMenu2 = new Menu( "Imprimir" );
        cMenu2.add( new MenuItem( "Preparar" ) );
        cMenu2.add( new MenuItem( "Imprimir Pgina" ) );
        cMenu2.add( new MenuItem( "Imprimir Todo" ) );
        cMenu1.add( cMenu2 );

        menu.add( cMenu1 );

        // Separador y opcin de salida
        menu.addSeparator();
        menu.add( new MenuItem( "Salir" ) );

        // Incorporamos el primer elemento a la barra de men
        menub.add( menu );

        // Segundo elemento desde el men principal 
        menu = new Menu( "Opciones" );

        // Una opcin cualquiera
        menu.add( new MenuItem( "Revisin" ) );
	
        // Incorporamos el segundo elemento a la barra de men
        menub.add( menu );

        setMenuBar( menub );
        }	


   
    public boolean handleEvent( Event evt ) {
        // Slo trataremos el evento de salida, el resto es ejemplo puro
        if( Event.WINDOW_DESTROY == evt.id  &&  this == evt.target )
            System.exit( 0 );

        // Los dems eventos los devolvemos a la clase superior
        return( super.handleEvent( evt ) );
        }



    public boolean action( Event evt,Object obj ) {
        // Slo tratamos el evento se salida de la aplicacin, el
        // resto los propagamos hacia arriba
        if( evt.target instanceof MenuItem  &&  obj.equals( "Salir" ) )
            System.exit( 0 );
       
        return( false );
        }


    public static void main( String args[] ) {
        Frame frame = new Cascada();

        frame.resize( 250,250 );
        frame.show();
        }
    }
                
//------------------------------------------- Final del fichero Cascada.java
