//  
//  ComponentesAWT.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 30-Jun-1996  09:10:23
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

public class ComponentesAWT extends Frame {

    public ComponentesAWT() {
        Panel bottomPanel = new Panel();
        Panel centerPanel = new Panel();
        MenuBar mb = new MenuBar();
        Menu m = new Menu( "Men" );
        m.add( new MenuItem( "Men Seleccin 1" ) );
        m.add( new CheckboxMenuItem( "Men Seleccin 2" ) );
        m.add( new MenuItem( "Men Seleccin 3" ) );
        mb.add( m );
        setMenuBar( mb );

        // Incoporamos los elementos pequeos en la zona inferior
        bottomPanel.add( new TextField( "Campo de Texto" ) );
        bottomPanel.add( new Button( "Botn" ) );
        bottomPanel.add( new Checkbox( "Casilla Verificacin" ) );

        Choice c = new Choice();
        c.addItem( "Seleccin Item 1" );
        c.addItem( "Seleccin Item 2" );
        c.addItem( "Seleccin Item 3" );
        bottomPanel.add( c );

        // En la zona central colocamos los elementos mayores
        centerPanel.setLayout( new GridLayout( 1,2 ) );

        // En la columna izquierda posicionamos un canvas
        centerPanel.add( new MiCanvas() );

        // En la zona central colocamos una etiqueta y una zona de texto
        Panel p = new Panel();
        p.setLayout( new BorderLayout() );
        p.add( "North",new Label( "Etiqueta",Label.CENTER ) );
        p.add( "Center",new TextArea( "Zona de Texto",5,20 ) );
        centerPanel.add( p );

        setLayout( new BorderLayout() );
        add( "South",bottomPanel );
        add( "Center",centerPanel );

        // En la columna derecha colocamos una lista de seleccin
        List l = new List( 3,false );
        l.addItem( "Lista item 1");
        l.addItem( "Lista item 2");
        l.addItem( "Lista item 3");
        l.addItem( "Lista item 4");
        l.addItem( "Lista item 5");
        l.addItem( "Lista item 6");
        l.addItem( "Lista item 7");
        l.addItem( "Lista item 8");
        l.addItem( "Lista item 9");
        add( "East",l ); 
        }


    public static void main( String args[] ) {
        ComponentesAWT window = new ComponentesAWT();

        window.setTitle("Los Componentes del AWT");
        window.pack();
        window.show();
        }
    }


class MiCanvas extends Canvas {
    public void paint( Graphics g ) {
        int w = size().width;
        int h = size().height;
        g.drawRect( 0,0,w-1,h-1 );
        g.drawString( "Canvas",
            ( w-g.getFontMetrics().stringWidth( "Canvas" ) )/2,10 );

        g.setFont( new Font( "Helvetica",Font.PLAIN,8 ) );
        g.drawLine( 10,10,100,100 );
        g.fillRect( 9,9,3,3 );
        g.drawString( "(10,10)",13,10 );
        g.fillRect( 49,49,3,3);
        g.drawString( "(50,50)",53,50 );
        g.fillRect( 99,99,3,3);
        g.drawString( "(100,100)",103,100 );
        }
    }

//------------------------------------ Final del fichero ComponentesAWT.java
