//  
//  Convertidor.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 21-Ago-1996  18:53:19
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Clase que nos permite introducir un nmero y nos lo presenta en
// diferentes bases
public class Convertidor extends Frame {
    int valorDecimal = 0;
    String valorX = new String( "0" );
    TextField dTexto,xTexto;

    public Convertidor() {
        super( "Convertidor Decimal" );

        // Creamos la barra de men, los botones de las bases y los
        // paneles que vamos a utilizar para posicionar los
        // Componentes
        MenuBar menub = new MenuBar();
        Button Bin = new Button( "Binario" );
        Button Octal = new Button( "Octal" );
        Button Hexa = new Button( "Hexadecimal" );
        Button Base36 = new Button( "Base36" );
        Panel p1 = new Panel();
        Panel p2 = new Panel();
        Panel p3 = new Panel();

        // Creamos el men desplegable
        Menu menu = new Menu( "Aplicacin" );
        menu.add( new CheckboxMenuItem( "Base36 Activa" ) );
        menu.add( new MenuItem( "Salir" ) );
        menub.add( menu );
        setMenuBar( menub );

        // Incorporamos los botones a uno de los paneles        
        p3.setLayout( new FlowLayout() );
        p3.add( Bin );
        p3.add( Octal );
        p3.add( Hexa );
        p3.add( Base36 );

        // Creamos los dos campos de texto que vamos a utilizar, uno
        // para la introduccin del nmero decimal que queremos
        // convertir y el otro para presentar el nmero convertido
        // Y asociamos cada uno de los campos, junto con su etiqueta
        // explicativa a uno de los paneles
        Label dEtiq = new Label( " Nmero Decimal:" );
        Label xEtiq = new Label( "Valor Convertido:" );
        dTexto = new TextField( Integer.toString( valorDecimal ),7 );
        xTexto = new TextField( valorX,32 );
        p1.setLayout( new FlowLayout( FlowLayout.LEFT ) );
        p2.setLayout( new FlowLayout( FlowLayout.LEFT ) );
        p1.add( dEtiq );
        p1.add( dTexto );
        p2.add( xEtiq );
        p2.add( xTexto );

        // Incorporamos los paneles a la ventana        
        add( "North",p1 );
        add( "Center",p2 );
        add( "South",p3 );
        }


    // Fija el tamao de la ventana y la presenta en pantalla
    public void start() {
        resize( 400,150 );
        show();
        }


    // Actualiza el texto convertido en el campo de texto que le
    // corresponde
    public void actualizaTexto() {
        xTexto.setText( valorX );
        }


    // Controlador de eventos, que hace caso solamente al evento de
    // destruccin de la ventana y a los de los botones, efectuando la
    // operacin de coversin que correponda al botn que se haya
    // pulsado y llama al mtodo que hace aparecer el nuevo valor en
    // el campo de texto del valor convertido
    public boolean handleEvent( Event evt ) {
        if( evt.target instanceof MenuItem ) 
            {
            if( "Salir".equals( ( (MenuItem)evt.target).getLabel() ) ) 
                {
                hide();
                dispose();
                System.exit( 0 );
                return false;
                }
            return( true );
            }
        else if( evt.target instanceof Button )
            {
            String boton = ( (Button)evt.target).getLabel();

            // Conversin del nmero decimal a binario
            if( boton.equals( "Binario" ) )
                {
                valorDecimal = Integer.parseInt( dTexto.getText() );
                valorX = Integer.toString( valorDecimal,2 );
                }           
            // Conversin del nmero decimal a octal
            if( boton.equals( "Octal" ) )
                {
                valorDecimal = Integer.parseInt( dTexto.getText() );
                valorX = Integer.toString( valorDecimal,8 );
                }
            // Conversin del nmero decimal a hexadecimal
            if( boton.equals( "Hexadecimal" ) )
                {
                valorDecimal = Integer.parseInt( dTexto.getText() );
                valorX = Integer.toString( valorDecimal,16 );
                }
            // Conversin del nmero decimal a un nmero en base 36
            if( boton.equals( "Base36" ) )
                {
                valorDecimal = Integer.parseInt( dTexto.getText() );
                valorX = Integer.toString( valorDecimal,36 );
                }

            actualizaTexto();
            return( true );
            }
        return false;
        }


    public static void main( String args[] ) {
        Convertidor c = new Convertidor();
        c.start();
        }
    }
                
//--------------------------------------- Final del fichero Convertidor.java
