//  
//  EventosList.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 31-Jul-1996  21:17:46
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Clase que va generando una lista con los eventos que el sistema va
// recogiendo. Se crea una lista y luego, por cada evento que se produce
// de aade un elemento a la lista, indicando el evento que se ha
// producido
public class EventosList extends Applet {
    List lista;

    public void init() {
        lista = new List( 25,false );
        add( lista );
        lista.addItem( "Evento init" );
        }

    public void start() {
        lista.addItem( "Evento start" );
        }

    public void destroy() {
        lista.addItem( "Evento destroy" );
        }

    public void paint( Graphics g ) {
        lista.addItem( "Evento paint" );
        }

    public void update( Graphics g ) {
        lista.addItem( "Evento update" );
        }

    public boolean mouseUp( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseUp en ("+x+","+y+")" );
        return false;
        }

    public boolean mouseDown( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseDown en ("+x+","+y+")" );
        return false;
        }

    public boolean mouseDrag( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseDrag en ("+x+","+y+")" );
        return false;
        }

    public boolean mouseMove( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseMove en ("+x+","+y+")" );
        return false;
        }

    public boolean mouseEnter( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseEnter en ("+x+","+y+")" );
        return false;
        }

    public boolean mouseExit( Event evt,int x, int y ) {
        lista.addItem( "Evento mouseExit" );
        return false;
        }

    public boolean keyDown( Event evt,int x ) {
        lista.addItem( "Evento keyDown, carcter "+(char)x+" pulsado" );
        return true;
        }

    public void getFocus() {
        lista.addItem( "Evento getFocus" );
        }

    public void gotFocus() {
        lista.addItem( "Evento gotFocus" );
        }

    public void lostFocus() {
        lista.addItem( "Evento lostFocus" );
        }
    }

    
//--------------------------------------- Final del fichero EventosList.java
