//  
//  EventosPro.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 26-Ago-1996  18:15:46
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Creamos una clase derivada de botn, en donde sobrecargamos su
// constructor para pasarle como parmetro un campo de texto donde
// pueda mostrar mensajes y tambin sobrecargamos su mtodo controlador 
// de eventos, para que cuando reciba el evento ACTION imprima un
// mensaje y lo propague hacia su padre
class BotonPro extends Button {
    private TextArea ta;

    public BotonPro( String str,TextArea ta ) {
        super( str );
        this.ta = ta;
        }

    public boolean handleEvent( Event evt ) {
        // Si es el evento ACTION imprime el mensaje
        if( evt.id == Event.ACTION_EVENT )
           ta.appendText( "Botn " + getLabel() + " recibe action...\n" );
        // Cualquier evento se lo propaga al padre
        return( super.handleEvent( evt ) );
        }
    }


// Clase Panel, en donde tambien hemos sobrecargado el constructor para
// permitirle presentar mensajes y adems sobrecargamos el controlador
// de eventos para que nos avise de cuando le llegan eventos propagados
// por sus hijos, imprimiendo un mensaje en ese caso indicando el evento
// que ha recibido
class PanelPro extends Panel {
    private String str;
    private TextArea ta;

    public PanelPro( String str,TextArea ta ) {
        super();
        this.str = str;
        this.ta = ta;
        }

    public Insets insets() {
        return new Insets( 5,5,5,5 );
        }

    public void paint( Graphics g ) {
        g.drawRect( 0,0,size().width-1,size().height-1 );
        }
	
    public boolean handleEvent( Event evt ) {
        if( evt.id == Event.ACTION_EVENT )
            ta.appendText( "Panel " + str + " recibe action...\n" );
        else if( evt.id == Event.MOUSE_DOWN )
            ta.appendText( "Panel " + str + " recibe mouse_down...\n" );
        // Propagamos el evento hacia el padre
        return( super.handleEvent( evt ) );
        }
    }

// Demostracin de la propagacin de los eventos
public class EventosPro extends Applet {
    TextArea ta = new TextArea();

    // Creamos dos paneles, en uno ponemos los botones y en el otro
    // el campo de texto y el panel que contiene los botones
    public void init() {
        setLayout( new BorderLayout() );
        add( "Center",ta );
        PanelPro p1 = new PanelPro( "1",ta );
        PanelPro p2 = new PanelPro( "2",ta );
        p2.add( new BotonPro( "Uno",ta ) );
        p2.add( new BotonPro( "Dos",ta ) );
        p1.add( p2 );
        add( "South",p1 );
        }

    // Fijamos las dimensiones que queremos
    public Dimension preferredSize() {
        return new Dimension( 400,230 );
        }

    public Insets insets() {
        return new Insets( 5,5,5,5 );
        }

    // Controlamos los eventos que nos llegan de los hijos
    public boolean handleEvent( Event evt ) {
        if( evt.id == Event.ACTION_EVENT )
            ta.appendText("Applet recibe action...\n\n" );
        else if( evt.id == Event.MOUSE_DOWN )
            ta.appendText("Applet recibe mouse_down...\n\n" );
        // Y los propagamos hacia el padre
        return( super.handleEvent( evt ) );
        }

    public static void main(String args[] ) {
        Frame f = new Frame( "Propagacin de Eventos" );
        EventosPro ep = new EventosPro();

        ep.init();
        f.add( "Center",ep );
        f.pack();
        f.show();
        }
    }

//---------------------------------------- Final del fichero EventosPro.java
