//  
//  EventosRaton.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 26-Ago-1996  18:48:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Clase que crea una zona de dibujo en la pantalla y va presentando una
// linea entre cada uno de los puntos que se vayan picando con el boton
// del ratn
public class EventosRaton extends Applet{
    boolean Pintar;
    int lastx,lasty;
    int newx,newy;

    public void init() {
        add( new Canvas() );

        Pintar = false;
        lastx = size().width / 2;
        lasty = size().height / 2;
        newx = newy = 0;
        }


    // Cuando el cursor entre en el dominio del applet, repintamos 
    // la linea, para que aparesca en pantalla ese lnea
    public boolean mouseEnter( Event evt,int x,int y ) {
        Pintar = true;

        repaint();
        return true;
        }


    // Tambin repintamos cuando el cursor abandona el applet para que
    // la lnea desaparezca de la pantalla
    public boolean mouseExit( Event evt,int x,int y ) {
        Pintar = false;

        repaint();
        return true;
        }


    // Con los movimientos del cursor vamos repintando
    public boolean mouseMove( Event evt,int x,int y ) {
        newx = x;
        newy = y;

        repaint();
        return true;
        }


    // Tomamos el puevo punto cuando se pulsa el botn del ratn
    // para volver a presentar a partir de ah la linea
    public boolean mouseDown( Event evt,int x,int y ) {
        lastx = newx;
        lasty = newy;

        repaint();
        return true;
        }


    // El mtodo paint pinta la lnea desde del ltimo punto que se
    // haya pulsado hasta la posicin en que actualmente se encuentre
    // el cursor
    public void paint( Graphics g ) {
        if( Pintar ) 
            g.drawLine( lastx,lasty,newx,newy );
        }


    public Dimension preferredSize() {
        return new Dimension( 400,100 );
        }


    public static void main( String args[] ) {
        Frame f = new Frame( "Eventos del Ratn" );
        EventosRaton er = new EventosRaton();

        er.init();

        f.add( "Center",er );
        f.pack();
        f.show();
        }
    }

//-------------------------------------- Final del fichero EventosRaton.java
