//  
//  Grupo.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 16-Dic-1996  13:21:28
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------
 
import java.awt.*;

// Extendemos la clase Panel para implementar nuestro nuevo Componente
public class Grupo extends Panel {
    String Rotulo;
    int altoTexto;
    int longTexto;
    int offset;
    static Font defFuente;
    FontMetrics metFuente;

    // Al contructor le pasamos el ttulo del Grupo
    public Grupo( String titulo ) {
        altoTexto = 20;
        longTexto = 20;
        offset = 10;
        Rotulo = titulo;
        setLayout( null );
        metFuente = getFontMetrics( defFuente );
        }

    public void paint( Graphics g ) {
        Dimension d = size();
        Font fuente = getFont();
        // Comprobamos que no haya ya una fuente seleccionada por defecto,
        // En caso de que no la haya, cogemos la nuestra
        if( fuente != null )
            metFuente = getFontMetrics( fuente );

        longTexto = metFuente.stringWidth( Rotulo );
        altoTexto = metFuente.getHeight();
        g.setColor( Color.gray );
        // A la hora de pintar el rectngulo que rodear al grupo, tenemos
        // en cuenta el alto de los caracteres que forman la fuente con
        // que estamos trabajando y el ancho de los caracteres, junto con
        // la longitud del texto
        g.drawRect( 0, altoTexto/2,d.width-3,d.height-altoTexto/2-3 );
        g.setColor( Color.white );
        g.drawRect( 1,altoTexto/2+1,d.width-3,d.height-altoTexto/2-3 );
        g.setColor( getBackground() );
        g.drawLine( offset,altoTexto/2,offset+longTexto+12,altoTexto/2 );
        g.drawLine( offset,altoTexto/2+1,offset+longTexto+12,altoTexto/2+1 );
        g.setColor( getForeground() );
        g.drawString( Rotulo,offset+6,altoTexto-3 );
        }

    // No manejamos los eventos, porque no tiene sentido, nuestro grupo
    // es una mera decoracin, as que pasamos los eventos hacia arriba
    public boolean handleEvent( Event evt ) {
        return( super.handleEvent( evt ) );
        }

    public Dimension preferredSize() {
        return( minimumSize() );
        }

    public Dimension minimumSize() {
        return( new Dimension( 100,100 ) );
        }

    // Nuestra fuente por defecto
    static {
        defFuente = new Font( "Dialog",0,12 );
        }
    }

//--------------------------------------------- Final del fichero Grupo.java
