//  
//  Habilitar.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 26-Ago-1996  19:57:40
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Clase Texto modificada para el control de los botones
class NTextField extends TextField {
    Component rgcomp[];

    // En el operador le pasamos un array de componentes que ser el
    // que mantenga controlado    
    public NTextField( Component rgcomp[] ) {
        super();

        // De entrada, todos los componentes estn deshabilitados
        this.rgcomp = rgcomp;
        for( int i=0; i < rgcomp.length; i++ )
            rgcomp[i].disable();
        }

    // Cuando se pulsa una tecla y se recibe el evento, se trata
    public boolean keyDown( Event evt,int nKey ) {
        boolean fin = true;
        int n = getText().length();

        // Teclas especiales
        if( ( nKey > 96 && nKey < 123 ) ||
            ( nKey > 64 && nKey < 91 ) ||
            ( nKey > 47 && nKey < 58 ) ||
            ( nKey == 32 ) )
            {
            fin = false;
            n++;
            }
        // Tecla de borrado hacia atrs
        else if( nKey == 8 )
            {
            fin = false;
            n--;
            }

        // Tambin controlamos la longitud del texto que se escribe en
        // el campo de texto, de forma que si se borran todos los
        // caracteres del campo, se deshabilitan los componentes
        if( n > 0 )
            {
            for( int i=0; i < rgcomp.length; i++ )
                rgcomp[i].enable();
            }
        else
            {
            for( int i=0; i < rgcomp.length; i++ )
                rgcomp[i].disable();
            }

        return( fin );
        }
    }


// Creamos el applet, en donde creamos dos botones que sern los que se
// controles, en cuando a su habilitacin, desde el contenido del campo
// de texto
public class Habilitar extends Applet { 

    public void init() {
      setLayout( new BorderLayout() );

      Component rgcomp[] = new Component[2];
      rgcomp[0] = new Button( "Aadir" );
      rgcomp[1] = new Button( "Borrar" );
      Panel p = new Panel();
      p.add( rgcomp[0] );
      p.add( rgcomp[1] );
      add( "South",p );
      add( "North",new NTextField( rgcomp ) );
      }

    public Insets insets() {
        return new Insets( 5,5,5,5 );
        }

    public static void main( String args[] ) {
        Frame f = new Frame( "Habilitacin" );
        Habilitar h = new Habilitar();
        h.init();

        f.add( "Center",h );
        f.pack();
        f.show();
        }
    }

//---------------------------------------- Final del fichero Habilitar.java
