//  
//  MiLayout.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 25-Jul-1996  20:32:40
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Implementacin de un controlador de posicionamiento propio, que va
// a permitir colocar los componenetes en cualquier lugar de su dominio
// Tenemos que sobrecargar o definir los mtodos que se utilizan en los
// LayoutManager para que todo funcione, aunque no hagan nada, porque 
// aunque nosotros no llamemos explcitamente a esos mtodos en ninguna
// ocasin, es el propio sistema el que puede hacerlo
public class MiLayout implements LayoutManager {

    // Constructor
    public MiLayout() {
        }


    // Mtodo para la incorporacin de componentes
    public void addLayoutComponent( String name,Component comp ) {
        }


    // Mtodo para eliminar componentes del controlador
    public void removeLayoutComponent( Component comp ) {
        }


    // Fija la dimensin del controaldor en funcin de la dimensin
    // de los componentes y su posicin, para que se vean todos en
    // el espacio de pantalla destinado al controlador
    public Dimension preferredLayoutSize( Container parent ) {
        Insets insets = parent.insets();
        int numero = parent.countComponents();
        int ancho = 0;
        int alto = 0;

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();
            Point p = comp.location();

            if( ( p.x + d.width ) > ancho )
                ancho = p.x + d.width;
            if( ( p.y + d.height ) > alto )
                alto = p.y + d.height;
            }

        return( new Dimension( insets.left + insets.right + ancho,
            insets.top + insets.bottom + alto ) );
        }

    
    // Controlamos la dimensin mnima que debe tener el controlador
    public Dimension minimumLayoutSize( Container parent ) {
        Insets insets = parent.insets();
        int numero = parent.countComponents();
        int ancho = 0;
        int alto = 0;

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();
            Point p = comp.location();

            if( ( p.x + d.width ) > ancho )
                ancho = p.x + d.width;
            if( ( p.y + d.height ) > alto )
                alto = p.y + d.height;
            }

        return( new Dimension( insets.left + insets.right + ancho,
            insets.top + insets.bottom + alto ) );
        }



    // Reescala los componentes a su tamao preferido en caso de que
    // se pueda hacer
    public void layoutContainer( Container parent ) {
        int numero = parent.countComponents();

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();

            comp.resize( d.width,d.height );
            }
        }
    }

//--------------------------------------- Final del fichero MiLayout.java
