//  
//  RangoRojo.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 21-Ago-1996  18:53:19
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Demostracin del uso de una barra de desplazamiento como medidor de 
// escalas. Se crea una barra y un texto asociado que va presentando
// la cifra por la que se mueve el indicador de la barra
public class RangoRojo extends Applet {
    Scrollbar rango;
    TextField valor;
    Label etiqueta;

    public void init() {
        // Al crear la barra se indica cual es el valor de los dos
        // extermos para que se pueda actualizar correctamente el
        // indicador
        rango = new Scrollbar( Scrollbar.HORIZONTAL,0,1,0,255 );
        valor = new TextField( "0",5 );
        etiqueta = new Label( "Rojo (0-255)" );

        setLayout( new GridLayout( 1,3 ) );
        valor.setEditable( false );

        add( etiqueta );
        add( rango );
        add( valor );
        }


    // Cuando se produce un evento en la barra de desplazamiento, se
    // actualiza el texto
    public boolean handleEvent( Event evt ) {
        if( evt.target instanceof Scrollbar )
            {
            valor.setText( 
                Integer.toString( ((Scrollbar)evt.target).getValue() ) );
            return( true );
            }

        return( super.handleEvent( evt ) );
        }
    }

//----------------------------------------- Final del fichero RangoRojo.java
