//  
//  VisorEventos.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 26-Ago-1996  18:07:23
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

// Aplicacin que nos abre una ventana donde aparecern todos los valores
// de los datos que componen cada evento que recibe el sistema
public class VisorEventos extends Frame {
    private TextField tfId;
    private TextField tfTarget;
    private TextField tfKey;
    private TextField tfMod;
    private TextField tfWhen;
    private TextField tfX;
    private TextField tfY;
    private TextField tfCC;
    private TextField tfArg;

    boolean EjecucionEnApplet = true;

    public VisorEventos() {
        super("Visualizador de Eventos");

        // Creamos el panel y fijamos el layout y las dimensiones
        // para ir colocando los valores de los datos
        Panel p;
        p = new Panel();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);

        GridBagConstraints gbs1 = new GridBagConstraints();
        GridBagConstraints gbs2 = new GridBagConstraints();

        gbs1.fill = GridBagConstraints.BOTH;
        gbs1.weighty = 0.5;

        gbs2.fill = GridBagConstraints.BOTH;
        gbs2.gridwidth = GridBagConstraints.REMAINDER;
        gbs2.weightx = 1.0;
        gbs2.weighty = 0.5;

        // Tipo de evento que se ha producido
        Component c;
        c = new Label( "Id" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfId = new TextField();
        tfId.setEditable( false );
        gbl.setConstraints( tfId,gbs2 );
        p.add( tfId );

        // Componente sobre el que se ha producido el evento
        c = new Label( "Target" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfTarget = new TextField();
        tfTarget.setEditable( false );
        gbl.setConstraints( tfTarget,gbs2 );
        p.add( tfTarget );

        // Tecla pulsada, en eventos de teclado
        c = new Label( "Key" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfKey = new TextField();
        tfKey.setEditable( false );
        gbl.setConstraints( tfKey,gbs2 );
        p.add( tfKey );

        // Combinacin en que se encuentran las teclas especiales
        c = new Label( "Modifiers" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfMod = new TextField();
        tfMod.setEditable( false );
        gbl.setConstraints( tfMod,gbs2 );
        p.add( tfMod );

        // Instante en que se ha producido el evento
        c = new Label( "When" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfWhen = new TextField();
        tfWhen.setEditable( false );
        gbl.setConstraints( tfWhen,gbs2 );
        p.add( tfWhen );

        // Coordenada X relativa al componente, donde se ha producido
        // el evento
        c = new Label("Coordenada X");
        gbl.setConstraints(c, gbs1);
        p.add(c);
        tfX = new TextField();
        tfX.setEditable( false );
        gbl.setConstraints( tfX,gbs2 );
        p.add( tfX );

        // Coordenada Y relativa al componente, donde se ha producido
        // el evento
        c = new Label("Coordenada Y");
        gbl.setConstraints(c, gbs1);
        p.add(c);
        tfY = new TextField();
        tfY.setEditable( false );
        gbl.setConstraints( tfY,gbs2 );
        p.add( tfY );

        // Nmero de clicks consecutivos de ratn
        c = new Label( "Cont. Clicks" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfCC = new TextField();
        tfCC.setEditable( false );
        gbl.setConstraints( tfCC,gbs2 );
        p.add( tfCC );

        // Argumento dependiente el evento que se haya producido
        c = new Label( "Argumento" );
        gbl.setConstraints( c,gbs1 );
        p.add( c );
        tfArg = new TextField();
        tfArg.setEditable( false );
        gbl.setConstraints( tfArg,gbs2 );
        p.add( tfArg );

        add( "Center",p );

        // Para generar algunos eventos diferentes del ratn y del
        // teclado, incorporamos al panel un bn y una lista de
        // seleccin
        p = new Panel();
        Button b = new Button( "Plsame" );
        p.add(b);

        Choice ch = new Choice();
        ch.addItem( "uno" );
        ch.addItem( "dos" );
        ch.addItem( "tres" );
        p.add( ch );

        add( "South",p );
        }


    // Controlador de eventos. Cuando se produce un evento, se
    // actualizan los campos de texto indicando los valores de los
    // datos que corresponden a ese evento
    public boolean handleEvent( Event evt ) {
        tfTarget.setText( evt.target.toString() );
        tfId.setText( String.valueOf( evt.id ) );
        tfKey.setText( String.valueOf( evt.key ) );
        tfCC.setText( String.valueOf( evt.clickCount ) );
        tfMod.setText( String.valueOf( evt.modifiers ) );
        tfWhen.setText( String.valueOf( evt.when ) );
        tfX.setText( String.valueOf( evt.x ) );
        tfY.setText( String.valueOf( evt.y ) );
        tfArg.setText( evt.arg == null ? "(null)" : evt.arg.toString() );

        if( evt.id == Event.WINDOW_DESTROY )
            {
            if( EjecucionEnApplet )
                {
                dispose();
                return true;
                }
            else
                System.exit( 0 );
            }   
  
        return( super.handleEvent( evt ) );
        }


    public static void main( String args[] ) {
        VisorEventos ve = new VisorEventos();

        ve.EjecucionEnApplet = false;

        ve.pack();
        ve.show();
        }
    }

//-------------------------------------- Final del fichero VisorEventos.java
