//  
//  CGrafico.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 31-Ago-1996  19:09:41
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class CGrafico extends Applet {
    Image dobleBuffer;
    Graphics miCG;

    public void init() {
        // Inicializa el doble buffer
        dobleBuffer = createImage( 300,300 );
        miCG = dobleBuffer.getGraphics();

        // Construye un rea grfica de trabajo
        miCG.setColor( Color.white );
        miCG.fillRect( 0,0,300,300 );
        resize( 500,450 );
        }


    public void paint( Graphics g ) {
        // Slo se tiene que presentar la imagen del buffer
        g.drawImage( dobleBuffer,0,0,this );
        }


    public void titulo() {
        // Obtiene la fuente de texto actual y la guardamos
        Font f = miCG.getFont(); 
        // Seleccionamos otro color y otra fuente para el ttulo
        miCG.setColor( Color.blue );
        miCG.setFont( new Font( "TimesRoman",Font.BOLD,20 ) );
        miCG.drawString( "Ejemplo de Cuadrado",15,50 );
        miCG.drawString( "con Crculos",15,70 );
        // Recuperamos la fuente original
        miCG.setFont( f );
        }


    public void cuadrado() {
        int x,y;

        // Seleccionamos otro color para el cuadrado
        miCG.setColor( Color.red );

        // Dibujamos circulos en los lados horizontales
        y = 100;
        for( x=100; x <= 200; x+=10 )
            {
            miCG.drawOval( x,y,20,20 );
            miCG.drawOval( x,y+100,20,20 );
            }
        // Ahora en los verticales
        x = 100;
        for( y=100; y <= 200; y+=10 )
            {
            miCG.drawOval( x,y,20,20 );
            miCG.drawOval( x+100,y,20,20 );
            }
        }


    public void start() {
        // Hace el dibujo off-line
        titulo();
        cuadrado();
        // Ahora muestra la imagen de golpe
        repaint();
        }
    }

//------------------------------------------ Final del fichero CGrafico.java
