//  
//  Cuadrados.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 31-Jul-1996  19:53:09
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;

public class Cuadrados extends Frame {
    float xA,yA,xB,yB,xC,yC,xD,yD;
    float xA1,yA1,xB1,yB1,xC1,yC1,xD1,yD1;
    float p,q,r;
    int xcentro,ycentro;

    static final int HOR_TAMANO = 300;
    static final int VER_TAMANO = 300;

    public Cuadrados() {
        q = (float)0.05;
        p = 1 - q;
        r = (float)0.95 * ( HOR_TAMANO/2 );

        xcentro = HOR_TAMANO / 2;
        ycentro = VER_TAMANO / 2;
        
        resize( HOR_TAMANO,VER_TAMANO );
        show();
        }


    public void paint( Graphics g ) {
        xA = xD = xcentro - r;
        xB = xC = xcentro + r;
        yA = yB = ycentro - r;
        yC = yD = ycentro + r;
        
        for( int i=0; i < 20; i++ )
            {
            g.drawLine( (int)xA,(int)yA,(int)xB,(int)yB );
            g.drawLine( (int)xB,(int)yB,(int)xC,(int)yC );
            g.drawLine( (int)xC,(int)yC,(int)xD,(int)yD );
            g.drawLine( (int)xD,(int)yD,(int)xA,(int)yA );
            xA1 = p*xA + q*xB;
            yA1 = p*yA + q*yB;
            xB1 = p*xB + q*xC;
            yB1 = p*yB + q*yC;
            xC1 = p*xC + q*xD;
            yC1 = p*yC + q*yD;
            xD1 = p*xD + q*xA;
            yD1 = p*yD + q*yA;
            
            xA = xA1;  xB = xB1;  xC = xC1;  xD = xD1;
            yA = yA1;  yB = yB1;  yC = yC1;  yD = yD1;
            }
        }


    public boolean mouseDown( Event evt,int x,int y ) {
        repaint();
        return true;
        }


    public static void main( String args[] ) {
        new Cuadrados();
        }
    }
    
//----------------------------------------- Final del fichero Cuadrados.java
