//
//  EjemploGraf.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
//
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Dec-1996  12:56:12
//
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Esta clase selecciona un color de un array predefinido
class SeleccionColor {
    private int i=0;

    // Array con los colores para poder manipular la zona
    // que se repintara
    private Color rgc[] = {
        Color.yellow,
        Color.red,
        Color.pink,
        Color.orange,
        Color.magenta,
        Color.green,
        Color.cyan,
        Color.blue
        };

    // Vamos cogiendo los colores que se suceden en el
    // array
    public Color generaColor() {
        i = i < rgc.length ? i : 0;
        return( rgc[i++] );
        }
    }


// Clase que utilizamos para crearnos nuestros propios paneles
// de forma que podemos declarar un color para ellos y as ver
// ms claramente el cambio de colores que se produce en cada
// uno de los repintados que hace el sistema 
class TutPanel extends Panel {
    private String str;
    private TextArea ta;
    private SeleccionColor sc;

    // Constructor de nuestro Panel
    public TutPanel( String str,TextArea ta ) {
        super();
        this.str = str;
        this.ta = ta;
        sc = new SeleccionColor();
        }

    public Insets insets() {
        return( new Insets( 5,5,5,5 ) );
        }

    public void paint( Graphics g ) {
        // Indica el panel sobre el que se est repintando
        ta.appendText( "Panel \""+str+"\" pintando...\n" );

        // Repinta el rectngulo con el color que le corresponda
        // del array para la visualizacin y despus pinta el
        // borde del rectngulo en negro para que se vean los
        // lmites
        g.setColor( sc.generaColor() );
        g.fillRect( 0,0,size().width-1,size().height-1 );
        g.setColor( Color.black );
        g.drawRect( 0,0,size().width-1,size().height-1 );
        }
    }

// Esta es la clase base del ejemplo
public class EjemploGraf extends Applet {
    private TextArea ta;
    private SeleccionColor sc;

    // Creamos todos los Componentes que forman la ventana,
    // incorporando los Paneles y botones
    public void init() {
        ta = new TextArea();
        sc = new SeleccionColor();

        // Fijamos el layout que vamos a utilizar para posicionar
        // los componentes sobre el
        setLayout( new BorderLayout() );
        add( "North",new Button( "Repintar Solamente el Panel" ) );
        add( "Center",ta );

        TutPanel p1 = new TutPanel( "1",ta );
        TutPanel p2 = new TutPanel( "2",ta );
        p2.add( new TutPanel( "2A",ta ) );
        p2.add( new TutPanel( "2B",ta ) );
        p1.add( p2 );
        add( "South",p1 );
        }

    public Dimension preferredSize() {
        return( new Dimension( 400,230 ) );
        }

    public Insets insets() {
        return( new Insets( 5,5,5,5 ) );
        }

    // Esta es la madre del cordero, llegue el evento que llegue, 
    // hacemos un repintado del applet, y ya se encargar el AWT de
    // repintar la zona que corresponda, que al cambiar nosotros 
    // el color con que va a hacerlo, veremos un repintado
    // multicolor, ya que en cada pasada utilizar un color
    // diferente
    public boolean action( Event evt,Object obj) {
        repaint();
        return( true );
        }

    // Metodo correspondiente al applet en si mismo
    public void paint( Graphics g ) {
        ta.appendText( "Applet pintando...\n" );

        // Repinta el rectngulo con el color que le corresponda
        // del array para la visualizacin y despus pinta el
        // borde del rectngulo en negro para que se vean los
        // lmites
        g.setColor( sc.generaColor() );
        g.fillRect( 0,0,size().width-1,size().height-1 );
        g.setColor( Color.black );
        g.drawRect( 0,0,size().width-1,size().height-1 );
        }

    // Metodo main() para cuando ejecutamos este cdigo como
    // aplicacin independiente
    public static void main( String args[] ) {
        Frame f = new Frame( "Ejemplo de Paint" );

        EjemploGraf ej = new EjemploGraf();
        ej.init();
        f.add( "Center",ej );
        f.pack();
        f.show();
        }
    }

//--------------------------------------- Final del fichero EjemploGraf.java
