//  
//  EspiralTest.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 31-Ago-1996  19:01:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

// Clase de ejemplo para dibujar en contextos grficos
class Espiral {
    // Al ser privada, las variables son slo accesibles por esta clase
    private int iniX,iniY,iniAncho,iniAlto;
    private int incremento;
    private Graphics cg;

    // constructor. crea una referencia local al buffer grfico y define
    // el azul como color de los objetos que se dibujen sobre ella
    public Espiral( Graphics g ) {
        cg = g;
        cg.setColor( Color.blue );
        }

    // Establece el tamao y posicin iniciales de la espiral
    public void setTamInicial( int x,int y,int w,int h ) {
        iniX = x;
        iniY = y;
        iniAncho = w;
        iniAlto = h;
        }

    // Establece el incremento para espaciar los giros
    public void setTamEspiral( int inc ) {
        incremento = inc;
        }

    // Construye la espiral
    public void creaEspiral() {
        int cX = iniX;
        int cY = iniY;

        // Dibuja lneas por pares, cubrindose entre s para formar la
        // espiral cuadrada hasta alcanzar el tamao del incremento
        while( iniAncho > incremento && iniAlto > incremento ) 
            {
            cg.drawLine( cX,cY,(cX+iniAncho),cY );
            cg.drawLine( (cX+iniAncho),cY,(cX+iniAncho),(cY+iniAlto) );
            cX += iniAncho;
            cY += iniAlto;
            iniAncho -= incremento;
            iniAlto -= incremento;

            cg.drawLine( cX,cY,(cX-iniAncho),cY );
            cg.drawLine( (cX-iniAncho),cY,(cX-iniAncho),(cY-iniAlto) );
            cX -= iniAncho;
            cY -= iniAlto;
            iniAncho -= incremento;
            iniAlto -= incremento;
            }
        }
    }

// Esta es la llamada a la clase desde un Applet Html
public class EspiralTest extends Applet {
    Image buffer;
    Espiral spiral;
    boolean cargado = false;

    synchronized public void init() {
        // crea un buffer donde dibujar
        buffer = createImage( 300,300 );
        // crea una nueva espiral
        spiral = new Espiral( buffer.getGraphics() );
        // establece el punto inicial y dimensiones
        spiral.setTamInicial( 10,10,200,200 );
        // establece el incremento
        spiral.setTamEspiral( 10 );
        // construye la espiral
        spiral.creaEspiral();
        }

    synchronized public void paint( Graphics g ) {
        g.drawImage( buffer,25,25,this );
        }
    }

//-------------------------------------- Final del fichero espiralTest.java
