//
//  FigElipse.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
//
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Dec-1996  13:02:51
//
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------
 
import java.awt.*;
import java.applet.Applet;

public class FigElipse extends Applet implements Figura {
    private TextField tfx,tfy,tfw,tfh,tfsa,tfaa;
    private TextField tfdox,tfdoy,tfdow,tfdoh;
    private TextField tffox,tffoy,tffow,tffoh;
    private TextField tfdax,tfday,tfdaw,tfdah,tfdasa,tfdaaa;
    private TextField tffax,tffay,tffaw,tffah,tffasa,tffaaa;
    private Panel p;
    private CardLayout cl;
    private TutCanvas tc;
    private Choice ch;

    public void init() {
        // Fijamos el fondo del applet igual que el de la pgina
        setBackground( Color.white );
        setLayout( new BorderLayout() );

        // Vamos a utilizar un CardLayout para ir cambiando las
        // presentaciones de los mtodos y los parmetros que se
        // van a introducir en funcin del tipo de figura que se
        // seleccione. Esto lo colocamos en la zona superior del
        // BorderLayout que gestiona el applet al completo
        Panel p1;
        p = new Panel();
        p.setLayout( cl = new CardLayout() );

        p.add( "Elipse",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "drawOval( " )  );
        p1.add( tfdox = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdoy = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdow = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdoh = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Elipse Rellena",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fillOval (" ) );
        p1.add( tffox = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffoy = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffow = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffoh = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Arco",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "drawArc( " ) );
        p1.add( tfdax = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfday = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdaw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdah = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdasa = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdaaa = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Arco Relleno",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fillArc( " ) );
        p1.add( tffax = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffay = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffaw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffah = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffasa = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffaaa = new TextField(3) );
        p1.add( new Label( " )" ) );
        add( "North",p );

        // En la zona central colocamos nuestro canvas para ir
        // pintando las primitivas que correspondan a las selecciones
        // que se introduzcan
        tc = new TutCanvas( this );
        add( "Center",tc );

        // En la parte inferior colocamos un botn para que cuando
        // lo pique el usuario se pinte la figura y una caja de
        // seleccin para que nos indique la figura que quiere
        // ver en pantalla
        p1 = new Panel();
        p1.add( new Button( " Pintar " ) );
        ch = new Choice();
        ch.addItem( "Elipse" );
        ch.addItem( "Elipse Rellena" );
        ch.addItem( "Arco" );
        ch.addItem( "Arco Relleno" );
        p1.add( ch );
        add( "South",p1 );

        tfx = tfdox;
        tfy = tfdoy;
        tfw = tfdow;
        tfh = tfdoh;
        tfsa = tfdasa;
        tfaa = tfdaaa;

        tfx.setText( "10" );
        tfy.setText( "10" );
        tfw.setText( "100" );
        tfh.setText( "100" );
        tfsa.setText( "90" );
        tfaa.setText( "110" );
        }

    // Este mtodo se encarga de recoger los valores numricos que
    // se introduzcan en los campos de texto. Si se meten letras
    // o cualquier cosa rara, toma como valor 0
    private int parseTextField( TextField tf ) {
        int n;

        try {
            n = Integer.parseInt( tf.getText() );
        } catch( NumberFormatException nfe ) {
            tf.setText( "0" );
            n = 0;
            }
        return( n );
        }

    // Sobrecargamos el metodo de pintura de nuestra interface
    // Figura, que como es la que implementa la clase TutCanvas,
    // har que nos aparezca en pantalla la imagen correspondiente
    // a la figura geomtrica que queremos pintar
    public void paintCallback( Graphics g ) {
        int x = parseTextField( tfx );
        int y = parseTextField( tfy );
        int w = parseTextField( tfw );
        int h = parseTextField( tfh );
        int sa = parseTextField( tfsa );
        int aa = parseTextField( tfaa );

        if( ch.getSelectedItem().equals( "Elipse" ) )
            g.drawOval( x,y,w,h );
        else if( ch.getSelectedItem().equals( "Elipse Rellena" ) )
            g.fillOval( x,y,w,h );
        else if( ch.getSelectedItem().equals( "Arco" ) )
            g.drawArc( x,y,w,h,sa,aa );
        else if( ch.getSelectedItem().equals( "Arco Relleno" ) )
            g.fillArc( x,y,w,h,sa,aa );
        }

    // Control de las opciones que seleccione el usuario, tanto 
    // para repintar lo que haya introducido como para la seleccin
    // de la figura que quiere presentar
    public boolean action( Event evt,Object obj ) {
        if( obj.equals( " Pintar " ) )
            {
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Elipse" ) )
            {
            tfdox.setText( tfx.getText() );
            tfdoy.setText( tfy.getText() );
            tfdow.setText( tfw.getText() );
            tfdoh.setText( tfh.getText() );
            tfx = tfdox;
            tfy = tfdoy;
            tfw = tfdow;
            tfh = tfdoh;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Elipse Rellena" ) )
            {
            tffox.setText( tfx.getText() );
            tffoy.setText( tfy.getText() );
            tffow.setText( tfw.getText() );
            tffoh.setText( tfh.getText() );
            tfx = tffox;
            tfy = tffoy;
            tfw = tffow;
            tfh = tffoh;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Arco" ) )
            {
            tfdax.setText( tfx.getText() );
            tfday.setText( tfy.getText() );
            tfdaw.setText( tfw.getText() );
            tfdah.setText( tfh.getText() );
            tfdasa.setText( tfsa.getText() );
            tfdaaa.setText( tfaa.getText() );
            tfx = tfdax;
            tfy = tfday;
            tfw = tfdaw;
            tfh = tfdah;
            tfsa = tfdasa;
            tfaa = tfdaaa;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Arco Relleno" ) )
            {
            tffax.setText( tfx.getText() );
            tffay.setText( tfy.getText() );
            tffaw.setText( tfw.getText() );
            tffah.setText( tfh.getText() );
            tffasa.setText( tfsa.getText() );
            tffaaa.setText( tfaa.getText() );
            tfx = tffax;
            tfy = tffay;
            tfw = tffaw;
            tfh = tffah;
            tfsa = tffasa;
            tfaa = tffaaa;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        return( false );
        }

    public Dimension preferredSize() {
        return new Dimension( 500,200 );
        }

    // Funcin para cuando queramos ejecutar esta aplicacin de forma
    // individual, en solitario
    public static void main( String args[] ) {
        Frame f = new Frame( "Elipses y Arcos" );

        FigElipse fo = new FigElipse();
        fo.init();
        f.add( "Center", fo );
        f.pack();
        f.show();
        }
    }

//----------------------------------------- Final del fichero FigElipse.java
