//
//  FigLinea.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
//
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Dec-1996  13:14:24
//
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------
 
import java.awt.*;
import java.applet.Applet;

public class FigLinea extends Applet implements Figura {
    private TextField tfx1,tfy1,tfx2,tfy2;

    private TutCanvas tc;

    public void init() {
        setBackground( Color.white );
        setLayout( new BorderLayout() );

        Panel p = new Panel();
        p.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );

        p.add( new Label( "drawLine( ") );
        p.add( tfx1 = new TextField(3) );
        p.add( new Label( "," ) );
        p.add( tfy1 = new TextField(3) );
        p.add( new Label( "," ) );
        p.add( tfx2 = new TextField(3) );
        p.add( new Label( ",") );
        p.add( tfy2 = new TextField(3) );
        p.add( new Label( " )" ) );
        add( "North",p );

        // En la zona central colocamos nuestro canvas para ir
        // pintando la lneas que correspondan a los datos
        // que se introduzcan
        tc = new TutCanvas( this );
        add( "Center",tc );

        // En la parte inferior colocamos un botn para que cuando
        // lo pique el usuario se pinte la lnea que corresponda a 
        // los parmetros de los campos de texto
        p = new Panel();
        p.add( new Button( " Pintar " ) );
        add( "South",p );

        tfx1.setText( "10" );
        tfy1.setText( "10" );
        tfx2.setText( "100" );
        tfy2.setText( "100" );
        }

    // Este mtodo se encarga de recoger los valores numricos que
    // se introduzcan en los campos de texto. Si se meten letras
    // o cualquier cosa rara, toma como valor 0
    private int parseTextField( TextField tf ) {
        int n;

        try {
            n = Integer.parseInt( tf.getText() );
        } catch( NumberFormatException nfe ) {
            tf.setText( "0" );
            n = 0;
            }
        return( n );
        }

    // Sobrecargamos el mtodo de pintura de nuestra interface
    // Figura, que como es la que implementa la clase TutCanvas,
    // har que nos aparezca en pantalla la imagen correspondiente
    // a la lnea que indiquen los parmetros fijados
    public void paintCallback( Graphics g ) {
        int x1 = parseTextField( tfx1 );
        int y1 = parseTextField( tfy1 );
        int x2 = parseTextField( tfx2 );
        int y2 = parseTextField( tfy2 );

        g.drawLine( x1,y1,x2,y2 );
        }

    // Controlamos el evento de repintado de la lnea
    public boolean action( Event evt,Object obj ) {
        if( obj.equals( " Pintar " ) )
            {
            tc.repaint();
            return( true );
            }
        return( false );
        }

    public Dimension preferredSize() {
        return new Dimension( 500,200 );
        }

    // Funcin para cuando queramos ejecutar esta aplicacin de forma
    // individual, en solitario
    public static void main( String args[] ){
        Frame f = new Frame( "Lneas" );

        FigLinea fl = new FigLinea();
        fl.init();
        f.add( "Center",fl );
        f.pack();
        f.show();
        }
    }

//------------------------------------------ Final del fichero FigLinea.java
