//
//  FigPoligono.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
//
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Dec-1996  13:22:51
//
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class FigPoligono extends Applet implements Figura {
    private Panel p;
    private CardLayout cl;
    private TutCanvas tc;
    private Choice ch;

    public void init() {
        setBackground( Color.white );
        setLayout( new BorderLayout() );

        // Vamos a utilizar un CardLayout para ir cambiando las
        // presentaciones de los mtodos y los parmetros que se
        // van a introducir en funcin del tipo de figura que se
        // seleccione. Esto lo colocamos en la zona superior del
        // BorderLayout que gestiona el applet al completo
        // En este caso, no dejamos que se introduzcan valores de
        // parmetros, sino que pintamos un polgono predeterminado y
        // slo dejamos al usuario que seleccione entre si quiere 
        // ver el polgono relleno o no
        Panel p1;
        p = new Panel();
        p.setLayout( cl = new CardLayout() );
        p.add( "Polgono",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "drawPolygon ( ... )" ) );
        p.add( "Polgono Relleno",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fillPolygon( ... )" ) );
        add( "North",p );

        // En la zona central colocamos nuestro canvas para ir
        // pintando las primitivas que correspondan a las selecciones
        // que se introduzcan
        tc = new TutCanvas( this );
        add( "Center",tc );

        // En la parte inferior colocamos un botn para que cuando
        // lo pique el usuario se pinte la figura y una caja de
        // seleccin para que nos indique la figura que quiere
        // ver en pantalla
        p1 = new Panel();
        p1.add( new Button( " Pintar " ) );
        ch = new Choice();
        ch.addItem( "Polgono" );
        ch.addItem( "Polgono Relleno" );
        p1.add( ch );
        add( "South",p1 );
        }

    // Sobrecargamos el mtodo de pintura de nuestra interface
    // Figura, que como es la que implementa la clase TutCanvas,
    // hara que nos aparezca en pantalla la imagen correspondiente
    // a la figura geomtrica que queremos pintar
    public void paintCallback( Graphics g ) {
        Polygon pg = new Polygon();

        pg.addPoint( 220,30 );
        pg.addPoint( 300,35 );
        pg.addPoint( 320,95 );
        pg.addPoint( 275,70 );
        pg.addPoint( 210,100 );
        pg.addPoint( 180,50 );

        if( ch.getSelectedItem().equals( "Polgono" ) )
            g.drawPolygon( pg );
        else if( ch.getSelectedItem().equals( "Polgono Relleno" ) )
            g.fillPolygon( pg );
        }

    // Control de las opciones que seleccione el usuario, tanto
    // para repintar lo que haya introducido como para la seleccin
    // de la figura que quiere presentar
    public boolean action( Event evt,Object obj ) {
        if( obj.equals( " Pintar " ) )
            {
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Polgono" ) )
            {
            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Polgono Relleno" ) )
            {
            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        return( false );
        }

    public Dimension preferredSize() {
        return new Dimension( 500,200 );
        }

    // Funcin para cuando queramos ejecutar esta aplicacin de forma
    // individual, en solitario
    public static void main( String args[] ) {
        Frame f = new Frame( "Polgonos" );

        FigPoligono fp = new FigPoligono();
        fp.init();
        f.add( "Center",fp );
        f.pack();
        f.show();
        }
    }

//-------------------------------------- Final del fichero FigPoligono.java
