//
//  FigRectangulo.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
//
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 02-Dec-1996  13:45:29
//
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------
 
import java.awt.*;
import java.applet.Applet;

public class FigRectangulo extends Applet implements Figura {
    private TextField tfx,tfy,tfw,tfh,tfaw,tfah;
    private TextField tfdrx,tfdry,tfdrw,tfdrh;
    private TextField tffrx,tffry,tffrw,tffrh;
    private TextField tfrrx,tfrry,tfrrw,tfrrh,tfrraw,tfrrah;
    private TextField tffrrx,tffrry,tffrrw,tffrrh,tffrraw,tffrrah;
    private TextField tf3rx,tf3ry,tf3rw,tf3rh;
    private TextField tff3rx,tff3ry,tff3rw,tff3rh;
    private Choice ch3r,chf3r,ch3;
    private Panel p;
    private CardLayout cl;
    private TutCanvas tc;
    private Choice ch;

    public void init() {
        setBackground( Color.white );
        setLayout( new BorderLayout() );

        // Vamos a utilizar un CardLayout para ir cambiando las
        // presentaciones de los mtodos y los parametros que se
        // van a introducir en funcin del tipo de figura que se
        // seleccione. Esto lo colocamos en la zona superior del
        // BorderLayout que gestiona el applet al completo
        // Para cada una de las primitivas, creamos un FlowLayout
        // que nos permite colocar los campos de texto para la
        // entrada de los parmetros que necesita esa primitiva
        Panel p1;
        p = new Panel();
        p.setLayout( cl = new CardLayout() );
        p.add( "Rectngulo",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "drawRect(" ) );
        p1.add( tfdrx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdrw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfdrh = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Rectngulo Relleno",p1 = new Panel() );
        p1.setLayout(new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fillRect(" ) );
        p1.add( tffrx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrh = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Rectngulo Redondeado",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "drawRoundRect(" ) );
        p1.add( tfrrx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfrry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfrrw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfrrh = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfrraw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tfrrah = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Rectngulo Redondeado Relleno", p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fillRoundRect(" ) );
        p1.add( tffrrx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrrw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrrh = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrraw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tffrrah = new TextField(3) );
        p1.add( new Label( " )" ) );

        p.add( "Rectngulo 3D",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "draw3DRect(" ) );
        p1.add( tf3rx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tf3ry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tf3rw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tf3rh = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( ch3r = new Choice() );
        ch3r.addItem( "true" );
        ch3r.addItem( "false" );
        p1.add( new Label( " )" ) );

        p.add( "Rectngulo 3D Relleno",p1 = new Panel() );
        p1.setLayout( new FlowLayout( FlowLayout.CENTER,0,0 ) );
        p1.add( new Label( "fill3DRect(" ) );
        p1.add( tff3rx = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tff3ry = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tff3rw = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( tff3rh = new TextField(3) );
        p1.add( new Label( "," ) );
        p1.add( chf3r = new Choice() );
        chf3r.addItem( "true" );
        chf3r.addItem( "false" );
        p1.add( new Label( " )" ) );
        add( "North",p );

        // En la zona central colocamos nuestro canvas para ir
        // pintando las primitivas que correspondan a las selecciones
        // que se introduzcan
        tc = new TutCanvas( this );
        add( "Center",tc );

        // En la parte inferior colocamos un botn para que cuando
        // lo pique el usuario se pinte la figura y una caja de
        // seleccin para que nos indique la figura que quiere
        // ver en pantalla
        p1 = new Panel();
        p1.add(new Button( " Pintar " ) );
        ch = new Choice();
        ch.addItem( "Rectngulo" );
        ch.addItem( "Rectngulo Relleno" );
        ch.addItem( "Rectngulo Redondeado" );
        ch.addItem( "Rectngulo Redondeado Relleno" );
        ch.addItem( "Rectngulo 3D" );
        ch.addItem( "Rectngulo 3D Relleno" );
        p1.add( ch );
        add( "South",p1 );
    
        tfx = tfdrx;
        tfy = tfdry;
        tfw = tfdrw;
        tfh = tfdrh;
        tfaw = tfrraw;
        tfah = tfrrah;
        ch3 = ch3r;

        tfx.setText( "10" );
        tfy.setText( "10" );
        tfw.setText( "100" );
        tfh.setText( "100" );
        tfaw.setText( "10" );
        tfah.setText( "10" );
        ch3.select( "true" );
        }

    // Este mtodo se encarga de recoger los valores numricos que
    // se introduzcan en los campos de texto. Si se meten letras
    // o cualquier cosa rara, toma como valor 0
    private int parseTextField( TextField tf ) {
        int n;

        try {
            n = Integer.parseInt( tf.getText() );
        } catch( NumberFormatException nfe ) {
            tf.setText( "0" );
            n = 0;
            }
        return( n );
        }

    // Sobrecargamos el mtodo de pintura de nuestra interface
    // Figura, que como es la que implementa la clase TutCanvas,
    // hara que nos aparezca en pantalla la imagen correspondiente
    // a la figura geomtrica que queremos pintar
    public void paintCallback( Graphics g ) {
        int x = parseTextField( tfx );
        int y = parseTextField( tfy );
        int w = parseTextField( tfw );
        int h = parseTextField( tfh );
        int aw = parseTextField( tfaw );
        int ah = parseTextField( tfah );
        boolean b = ch3.getSelectedItem().equals( "true" );

        if( ch.getSelectedItem().equals( "Rectngulo" ) )
            g.drawRect( x,y,w,h );
        else if( ch.getSelectedItem().equals( "Rectngulo Relleno" ) )
            g.fillRect( x,y,w,h );
        else if( ch.getSelectedItem().equals( "Rectngulo Redondeado" ) )
            g.drawRoundRect( x,y,w,h,aw,ah );
        else if( ch.getSelectedItem().equals( "Rectngulo Redondeado Relleno" ) )
            g.fillRoundRect( x,y,w,h,aw,ah );
        else if( ch.getSelectedItem().equals( "Rectngulo 3D" ) )
            g.draw3DRect( x,y,w,h,b );
        else if( ch.getSelectedItem().equals( "Rectngulo 3D Relleno" ) )
            g.fill3DRect( x,y,w,h,b );
        }

    // Control de las opciones que seleccione el usuario, tanto
    // para repintar lo que haya introducido como para la seleccin
    // de la figura que quiere presentar
    public boolean action( Event evt,Object obj ) {
        if( obj.equals( " Pintar " ) )
            {
            tc.repaint();
            return( true );
            }
        else if( obj.equals("Rectngulo" ) )
            {
            tfdrx.setText( tfx.getText() );
            tfdry.setText( tfy.getText() );
            tfdrw.setText( tfw.getText() );
            tfdrh.setText( tfh.getText() );
            tfx = tfdrx;
            tfy = tfdry;
            tfw = tfdrw;
            tfh = tfdrh;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Rectgulo Relleno" ) )
            {
            tffrx.setText( tfx.getText() );
            tffry.setText( tfy.getText() );
            tffrw.setText( tfw.getText() );
            tffrh.setText( tfh.getText() );
            tfx = tffrx;
            tfy = tffry;
            tfw = tffrw;
            tfh = tffrh;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Rectgulo Redondeado" ) )
            {
            tfrrx.setText( tfx.getText() );
            tfrry.setText( tfy.getText() );
            tfrrw.setText( tfw.getText() );
            tfrrh.setText( tfh.getText() );
            tfrraw.setText( tfaw.getText() );
            tfrrah.setText( tfah.getText() );
            tfx = tfrrx;
            tfy = tfrry;
            tfw = tfrrw;
            tfh = tfrrh;
            tfaw = tfrraw;
            tfah = tfrrah;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Rectgulo Redondeado Relleno" ) )
            {
            tffrrx.setText( tfx.getText() );
            tffrry.setText( tfy.getText() );
            tffrrw.setText( tfw.getText() );
            tffrrh.setText( tfh.getText() );
            tffrraw.setText( tfaw.getText() );
            tffrrah.setText( tfah.getText() );
            tfx = tffrrx;
            tfy = tffrry;
            tfw = tffrrw;
            tfh = tffrrh;
            tfaw = tffrraw;
            tfah = tffrrah;

            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Rectgulo 3D" ) )
            {
            tf3rx.setText( tfx.getText() );
            tf3ry.setText( tfy.getText() );
            tf3rw.setText( tfw.getText() );
            tf3rh.setText( tfh.getText() );
            ch3r.select( ch3.getSelectedItem() );
            tfx = tf3rx;
            tfy = tf3ry;
            tfw = tf3rw;
            tfh = tf3rh;
            ch3 = ch3r;
        
            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        else if( obj.equals( "Rectngulo 3D Relleno" ) )
            {
            tff3rx.setText( tfx.getText() );
            tff3ry.setText( tfy.getText() );
            tff3rw.setText( tfw.getText() );
            tff3rh.setText( tfh.getText() );
            chf3r.select( ch3.getSelectedItem() );
            tfx = tff3rx;
            tfy = tff3ry;
            tfw = tff3rw;
            tfh = tff3rh;
            ch3 = chf3r;
    
            cl.show( p,(String)obj );
            tc.repaint();
            return( true );
            }
        return( false );
        }

    public Dimension preferredSize() {
        return( new Dimension( 500,200 ) );
        }

    // Funcin para cuando queramos ejecutar esta aplicacin de forma
    // individual, en solitario
    public static void main( String args[] ) {
        Frame f = new Frame( "Rectngulos" );

        FigRectangulo fr = new FigRectangulo();
        fr.init();
        f.add( "Center",fr );
        f.pack();
        f.show();
        }
    }

//------------------------------------- Final del fichero FigRectangulo.java
