//  
//  Lineas.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 11-Sep-1996  21:55:43
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Lineas extends Applet {
    int LINEAS = 25;
    int gSup = 3;
    int gInf = 3;
    int gIzq = 2;
    int gDch = 6;
    int apAncho,apAlto;
    int gLineas[][] = new int[LINEAS][4];

    public void init() {
        Dimension d = size();
        apAncho = d.width;
        apAlto = d.height; 
        }


    // Arranque del thread, donde se inicializa en un punto cualquiera
    // Y se lanzan los clculos
    public void start() {
        gLineas[0][0] = aleatorio( apAncho );
        gLineas[0][1] = aleatorio( apAlto );
        gLineas[0][2] = aleatorio( apAncho );
        gLineas[0][3] = aleatorio( apAlto );

        for( int i=1; i < LINEAS; i++ )
            {
            CopiaLinea( i,i-1 );
            RecalcLinea( i );
            }
        repaint();
        }


    // Primero copia las lneas para pasar a las siguiente posiciones
    // recalcula y pinta de nuevo, con ello se da siempre la sensacin
    // de continuidad y no dan saltos entre cada vez que se pinta
    public void paint( Graphics g ) {
        while( true )
            {
            for( int i=LINEAS-1; i > 0; i-- )
                CopiaLinea( i,i-1 );
            RecalcLinea( 0 );
            g.setColor( Color.black );
            g.drawLine( gLineas[0][0],gLineas[0][1],
                gLineas[0][2],gLineas[0][3] );
            g.setColor( getBackground() );
            g.drawLine( gLineas[LINEAS-1][0],gLineas[LINEAS-1][1],
                gLineas[LINEAS-1][2],gLineas[LINEAS-1][3] );
            }
        }


    // Copia la lnea dentro del array de vectores
    private void CopiaLinea( int desde,int hasta ) {
        for( int i=0; i < 4; i++ )
            gLineas[desde][i] =  gLineas[hasta][i];
        }


    // Devuelve un nmero pseudo-aleatorio
    public int aleatorio( int rango ) {
        double retornoMath;

        retornoMath = Math.random();
        return( (int)(retornoMath * rango) );
        }


    // Recalcula la posicin en que se va a encontrar cada una de
    // las lneas en la siguiente secuencia
    private void RecalcLinea( int i ) {
        gLineas[i][1] += gSup;
        if( (gLineas[i][1] < 0 )  ||  (gLineas[i][1] > apAlto) )
            {
            gSup *= -1;
            gLineas[i][1] += 2*gSup;
            }

        gLineas[i][3] += gInf;
        if( (gLineas[i][3] < 0 )  ||  (gLineas[i][3] > apAlto) )
            {
            gInf *= -1;
            gLineas[i][3] += 2*gInf;
            }

        gLineas[i][0] += gIzq;
        if( (gLineas[i][0] < 0 )  ||  (gLineas[i][0] > apAncho) )
            {
            gIzq *= -1;
            gLineas[i][0] += 2*gIzq;
            }

        gLineas[i][2] += gDch;
        if( (gLineas[i][2] < 0 )  ||  (gLineas[i][2] > apAncho) )
            {
            gDch *= -1;
            gLineas[i][2] += 2*gDch;
            }
        }
    }

//-------------------------------------------- Final del fichero Lineas.java
