//  
//  Ojos.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 23-Ago-1996  06:26:10
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y est sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Ojos extends Applet {
    int Mx = -1;
    int My = -1;
    int OjoR1;
    int OjoR2;
    int Ancho;
    int Alto;
    int OjoIzq;
    int OjoDch;
    int OjoPY;
    Color Pupila = Color.black;
    Color Iris = Color.green.brighter();
    Color Orbita = Color.white;
    Image Imagen;
    Graphics OjoCG;
                            

    public void init() {
        setBackground( Color.darkGray );
        Dimension d = size();
 
        // Fijamos las variables que nos van a posicionar los
        // ojos sobre el applet
        OjoIzq = d.width >> 2;
        OjoDch = OjoIzq * 3;
        OjoPY = d.height >> 2;

        OjoR2 = d.width >> 4;
        OjoR1 = d.width >> 5;
        Ancho = ( d.width >> 3 ) + OjoR1;
        Alto = Ancho >> 1;
        }


    public void update( Graphics g ) {
        paint( g );
        }

           
    // Funcion auxiliar, para que no se desmanden los valores
    // y no se los salgan los ojos de las orbitas
    int swap( int i,int c ) {
        if( i > c )
            i = c;
        else if( i < -c )
            i = -c;
      return( i );
      }


    // Pintamos el ojo sobre el applet
    void pintaOjo( Graphics g,int x ) {
        // Fijamos los desplazamientos, las nuevas posiciones de
        // referencia, en funcion de la posicion del cursor del
        // raton, determinada por Mx y My
        int dx = x-Mx;
        int dy = OjoPY-My;
                                      
        // Pintamos el ojo solamente bordeado, es decir, cerrado
        if( dx < Ancho  &&  dx > -Ancho  &&  dy < Alto  &&  dy > -Alto ) 
            {
            g.setColor( getBackground() );
            g.fillOval( x-Ancho,OjoPY-Alto,Ancho << 1,Alto << 1 );
            g.setColor( getBackground().brighter() );
            g.drawOval( x-Ancho,OjoPY-Alto,Ancho << 1,Alto << 1 );
            }
        else 
            {                                                   
            // Pintamos el hueco del ojo, por el que se movera el iris
            g.setColor( Orbita );
            g.fillOval( x-Ancho,OjoPY-Alto,Ancho << 1,Alto << 1 );

            int y = OjoPY;
            dx = swap( dx >> 3,OjoR1 << 1 );
            dy = swap( dy >> 5,OjoR1 >> 1 );
            if( Mx >= 0  &&  My >= 0 ) 
                {
                x -= dx;
                y -= dy;
                }                                                     

            // Pintamos el iris, sobre el que se movera la pupila
            g.setColor( Iris );
            g.fillOval( x-OjoR2,y-OjoR2,OjoR2 << 1,OjoR2 << 1 );
            if( Mx >= 0  &&  My >= 0 ) 
                {
                x -= ( dx >> 1 );
                y -= dy;
                }                                                

            // Pintamos la pupila dentro del iris
            g.setColor( Pupila );
            g.fillOval( x-OjoR1,y-OjoR1,OjoR1 << 1,OjoR1 << 1 );
            }
        }


    public void paint( Graphics g ) {
        Dimension d = size();
        
        // La primera vez que se llama a este metodo, todavia no
        // hay nada, asi que creamos el soporte de los ojos
        if( Imagen == null || OjoCG == null ) 
            {
            Imagen = createImage( d.width,d.height >> 1 );
            OjoCG = Imagen.getGraphics();
            }                                              

        // Pintamos los ojos
        OjoCG.setColor( getBackground() );
        OjoCG.fillRect( 0,0,d.width,d.height );
        pintaOjo( OjoCG,OjoIzq );
        pintaOjo( OjoCG,OjoDch );
        g.drawImage( Imagen,0,0,this );
        }

                                         
    // Cuando movemos el cursos dentro del applet, recibimos las 
    // coordenadas y repintamos el ojo
    public boolean mouseMove( Event evt,int x,int y ) {
        Mx = x;
        My = y;
        repaint();

        return true;
        }

                                      
    // Si nos llega el evento de que el raton se ha salido del applet
    // ponemos los todo en el centro, con los ojos espantados,
    // como si se hubiese visto al diablo
    public boolean mouseExit( Event evt,int x,int y ) {
        Mx = My = -1;
        repaint();

        return true;
        }
    }

//---------------------------------------------- Final del fichero Ojos.java
