//  
//  Taza.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 31-Ago-1996  19:12:14
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;

public class Taza extends Applet {
    Image imagenes[];
    MediaTracker tracker;
    int index = 0;
    int maxAncho,maxAlto;

    // Componentes off-screen para el doble buffering
    Image offScrImage;
    Graphics offScrCG;
    boolean cargado = false;

    // Inicializa el applet. Establece el tamao y carga las imgenes
    public void init() {
        // Establece el supervisor de imgenes y dimensiones
        tracker = new MediaTracker( this );
        maxAncho = 78;
        maxAlto = 128;
        imagenes = new Image[6];

        // Establece el doble buffer y cambia el tamao del applet
        try {
            offScrImage = createImage( maxAncho,maxAlto );
            offScrCG = offScrImage.getGraphics();
            offScrCG.setColor( Color.lightGray );
            offScrCG.fillRect( 0,0,maxAncho,maxAlto );
            resize( maxAncho,maxAlto );
        } catch( Exception e ) {
            e.printStackTrace();
            }

        // Carga las imgenes en un array
        for( int i=0; i < 6; i++ )
            {
            String imageFich = 
                new String( "taza"+String.valueOf(i+1)+".gif" );
            imagenes[i] = getImage( getDocumentBase(),imageFich );
            // Pasamos esta imagen al tracker
            tracker.addImage( imagenes[i],i );
            }

        try {
            // Utilizamos el tracker para asegurar que se cargarn 
            // todas las imgenes
            tracker.waitForAll();
        } catch( InterruptedException e ) {
            }
        cargado = true;
        }
        

    // Pinta el fotograma actual
    public void paint( Graphics g ) {
        if( cargado )
            {
            // Copia del doble buffer a la pantalla
            g.drawImage( offScrImage,0,0,this );
            // Hacemos una pausa y cogemos la siguiente imagen
            timerloop();
            }
        }


    // Establecemos la primera imagen
    public void start() {
        index = 0;

        if( tracker.checkID( index ) )
            // Pintamos en el doble buffer
            offScrCG.drawImage( imagenes[index],0,0,this );
        }


    // Actualiza los fotogramas para que avance la animacin
    public void timerloop() {
        // Se asegura que la imagen est presente y la mete en el buffer
        if( tracker.checkID( index ) ) 
            {
            // Obtiene la siguiente imagen
            offScrCG.drawImage( imagenes[index],0,0,this );
            index++;

            // Vuelve al principio de la animacin
            if( index >= imagenes.length )
                index = 0;
            }
        // Bucle de retardo
        for( int retardo=0; retardo < 200000; retardo++ );
        // Dibujamos el siguiente fotograma
        repaint();
        }
    }

//---------------------------------------------- Final del fichero Taza.java
