//  
//  Tercio.java
//  Copyright (c) 1996, Agustin Froufe
//  Todos los derechos reservados.
//  
//  No se asume ninguna  responsabilidad por el  uso o  alteracion  de este
//  software.  Este software se proporciona COMO ES, sin garantia de ningun
//  tipo de su funcionamiento y en ningun caso sera el autor responsable de
//  daos o perjuicios que se deriven del mal uso del software,  aun cuando
//  este haya sido notificado de la posibilidad de dicho dao.
// 
//   Compilador: javac 1.0
//        Autor: Agustin Froufe
//     Creacion: 11-Sep-1996  23:15:04
// 
//--------------------------------------------------------------------------
//  Esta informacion no es necesariamente definitiva y esta sujeta a cambios
//  que pueden ser incorporados en cualquier momento, sin avisar.
//--------------------------------------------------------------------------

import java.awt.*;
import java.applet.Applet;
import java.util.Vector;

public class Tercio extends Applet {
    int apAncho,apAlto;
    Vector finPuntos = new Vector();

    public void init() {
        apAncho = size().width;
        apAlto = size().height;

        finPuntos.addElement( new Float( 0.0f ) );
        finPuntos.addElement( new Float( 1.0f ) );
        }

    public void paint( Graphics g ) {
        float x1,x2;
        Float tmpFloat;

        for( int i=0; i < apAncho; i+=5 ) 
            {
            // Pintamos las lineas
            for( int j=0; j < finPuntos.size(); j+=2 )
                {
                tmpFloat = (Float)finPuntos.elementAt( j );
                x1 = tmpFloat.floatValue();
                tmpFloat = (Float)finPuntos.elementAt( j+1 );
                x2 = tmpFloat.floatValue();
                g.drawLine( Math.round( x1*apAncho ),i,
                    Math.round( x2*apAncho),i );
                }
            // Eliminamos el tercio medio de las lineas
            BorraSegmentos();
            // Comprobamos que no nos salimos de la pantalla
            tmpFloat = (Float)finPuntos.elementAt( 0 );
            x1 = tmpFloat.floatValue();
            tmpFloat = (Float)finPuntos.elementAt( 1 );
            x2 = tmpFloat.floatValue();
            if( Math.round( x1*apAncho ) == Math.round( x2*apAncho ) )
                break;
            }
        }

    private void BorraSegmentos() {
        int indice = 0;
        int fin = finPuntos.size();

        for( int i=0; i < fin; i+=2 )
            {
            BorraTercioMedio( indice,indice+1 );
            indice += 4;
            }
        }

    private void BorraTercioMedio( int izqda,int dcha ) {
        float gap;
        float x1,x2;
        Float tmpFloat1,tmpFloat2;

        tmpFloat1 = (Float)finPuntos.elementAt( izqda );
        tmpFloat2 = (Float)finPuntos.elementAt( dcha );
        gap = tmpFloat2.floatValue() - tmpFloat1.floatValue();
        x1 = tmpFloat1.floatValue() + gap/3.0f;
        x2 = tmpFloat2.floatValue() - gap/3.0f;
        finPuntos.insertElementAt( new Float( x2 ),dcha ); 
        finPuntos.insertElementAt( new Float( x1 ),dcha ); 
        }
    }

//-------------------------------------------- Final del fichero Tercio.java
